/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.GlobalAddressFactory;
import java.util.Optional;
import javax.inject.Named;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttGlobalAddressFactory
extends GlobalAddressFactory<MqttAddress> {
    private static final String SUPPORTED_TRANSPORT_MQTT = "mqtt";
    private final String defaultGbid;
    private final String localChannelId;
    private MqttTopicPrefixProvider mqttTopicPrefixProvider;

    @Inject
    public MqttGlobalAddressFactory(@Named(value="joynr.internal.messaging.gbidArray") String[] gbids, @Named(value="joynr.messaging.channelid") String localChannelId, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        this.defaultGbid = gbids[0];
        this.localChannelId = localChannelId;
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
    }

    public MqttAddress create() {
        return new MqttAddress(this.defaultGbid, this.mqttTopicPrefixProvider.getUnicastTopicPrefix() + this.localChannelId);
    }

    public boolean supportsTransport(Optional<String> transport) {
        return SUPPORTED_TRANSPORT_MQTT.equals(transport.isPresent() ? transport.get() : null);
    }
}

