/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageInProgressObserver;
import io.joynr.messaging.mqtt.MqttMessagingSkeleton;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.MessageProcessedHandler;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSubscriptionsMqttMessagingSkeleton
extends MqttMessagingSkeleton {
    private static final Logger logger = LoggerFactory.getLogger(SharedSubscriptionsMqttMessagingSkeleton.class);
    private static final String NON_ALPHA_REGEX_PATTERN = "[^a-zA-Z]";
    private final String channelId;
    private final String sharedSubscriptionsTopic;
    private final AtomicBoolean subscribedToSharedSubscriptionsTopic;
    private final String replyToTopic;
    private JoynrMqttClient replyClient;
    boolean separateReplyMqttClient;

    public SharedSubscriptionsMqttMessagingSkeleton(String ownTopic, String replyToTopic, MessageRouter messageRouter, MessageProcessedHandler messageProcessedHandler, MqttClientFactory mqttClientFactory, String channelId, MqttTopicPrefixProvider mqttTopicPrefixProvider, RawMessagingPreprocessor rawMessagingPreprocessor, Set<JoynrMessageProcessor> messageProcessors, String ownGbid, RoutingTable routingTable, boolean separateReplyMqttClient, String backendUid, MqttMessageInProgressObserver mqttMessageInProgressObserver) {
        super(ownTopic, messageRouter, messageProcessedHandler, mqttClientFactory, mqttTopicPrefixProvider, rawMessagingPreprocessor, messageProcessors, ownGbid, routingTable, backendUid, mqttMessageInProgressObserver);
        this.replyToTopic = replyToTopic;
        this.channelId = channelId;
        this.sharedSubscriptionsTopic = this.createSharedSubscriptionsTopic();
        this.subscribedToSharedSubscriptionsTopic = new AtomicBoolean(false);
        this.separateReplyMqttClient = separateReplyMqttClient;
        this.replyClient = mqttClientFactory.createReplyReceiver(ownGbid);
    }

    @Override
    public void init() {
        logger.debug("Initializing shared subscriptions MQTT skeleton (ownGbid={}) ...", (Object)this.ownGbid);
        if (this.separateReplyMqttClient) {
            this.replyClient.setMessageListener(this);
            this.replyClient.start();
            this.mqttClientFactory.connect(this.replyClient);
        }
        super.init();
    }

    @Override
    protected void subscribe() {
        this.subscribeToReplyTopic();
        this.subscribeToSharedTopic();
    }

    protected void subscribeToReplyTopic() {
        String topic = this.replyToTopic + "/#";
        logger.info("Subscribing to reply-to topic: {}", (Object)topic);
        this.replyClient.subscribe(topic);
    }

    protected void subscribeToSharedTopic() {
        logger.info("Subscribing to shared topic: {}", (Object)this.sharedSubscriptionsTopic);
        this.client.subscribe(this.sharedSubscriptionsTopic);
        this.subscribedToSharedSubscriptionsTopic.set(true);
    }

    private String createSharedSubscriptionsTopic() {
        StringBuilder sb = new StringBuilder("$share/");
        sb.append(this.sanitiseChannelIdForUseAsTopic());
        sb.append("/");
        sb.append(this.ownTopic);
        sb.append("/#");
        return sb.toString();
    }

    private String sanitiseChannelIdForUseAsTopic() {
        String result = this.channelId.replaceAll(NON_ALPHA_REGEX_PATTERN, "");
        if (result.isEmpty()) {
            throw new IllegalArgumentException(String.format("The channel ID %s cannot be converted to a valid MQTT topic fragment because it does not contain any alpha characters.", this.channelId));
        }
        return result;
    }
}

