/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.messaging.IMessagingSkeletonFactory;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageInProgressObserver;
import io.joynr.messaging.mqtt.MqttMessagingSkeletonFactory;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.SharedSubscriptionsMqttMessagingSkeletonFactory;
import io.joynr.messaging.routing.MessageProcessedHandler;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.RoutingTable;
import java.util.HashSet;
import java.util.Set;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingSkeletonProvider
implements Provider<IMessagingSkeletonFactory> {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingSkeletonProvider.class);
    protected MqttClientFactory mqttClientFactory;
    protected boolean sharedSubscriptionsEnabled;
    @Inject(optional=true)
    @Named(value="property_mqtt_global_address")
    private Address ownAddressInjected = new Address();
    @Inject(optional=true)
    @Named(value="property_mqtt_reply_to_address")
    private Address replyToAddressInjected = new Address();
    protected MqttAddress ownAddress;
    protected MqttAddress replyToAddress;
    protected MessageRouter messageRouter;
    protected MessageProcessedHandler messageProcessedHandler;
    protected String channelId;
    protected MqttTopicPrefixProvider mqttTopicPrefixProvider;
    protected RawMessagingPreprocessor rawMessagingPreprocessor;
    protected Set<JoynrMessageProcessor> messageProcessors;
    protected final String[] gbids;
    protected final RoutingTable routingTable;
    protected final boolean separateMqttReplyReceiver;
    protected final MqttMessageInProgressObserver mqttMessageInProgressObserver;
    protected final String backendUid;

    @Inject
    public MqttMessagingSkeletonProvider(@Named(value="joynr.internal.messaging.gbidArray") String[] gbids, @Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") boolean enableSharedSubscriptions, @Named(value="joynr.messaging.separatereplyreceiver") boolean separateMqttReplyReceiver, MessageRouter messageRouter, MessageProcessedHandler messageProcessedHandler, MqttClientFactory mqttClientFactory, @Named(value="joynr.messaging.channelid") String channelId, MqttTopicPrefixProvider mqttTopicPrefixProvider, RawMessagingPreprocessor rawMessagingPreprocessor, Set<JoynrMessageProcessor> messageProcessors, RoutingTable routingTable, @Named(value="joynr.backend.uid") String backendUid, MqttMessageInProgressObserver mqttMessageInProgressObserver) {
        this.sharedSubscriptionsEnabled = enableSharedSubscriptions;
        this.rawMessagingPreprocessor = rawMessagingPreprocessor;
        this.messageProcessors = messageProcessors != null ? new HashSet<JoynrMessageProcessor>(messageProcessors) : null;
        this.messageRouter = messageRouter;
        this.messageProcessedHandler = messageProcessedHandler;
        this.mqttClientFactory = mqttClientFactory;
        this.channelId = channelId;
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
        this.gbids = (String[])gbids.clone();
        this.routingTable = routingTable;
        this.separateMqttReplyReceiver = separateMqttReplyReceiver;
        this.backendUid = backendUid;
        this.mqttMessageInProgressObserver = mqttMessageInProgressObserver;
    }

    @Inject
    public void init() {
        if (!(this.ownAddressInjected instanceof MqttAddress)) {
            throw new JoynrIllegalStateException("Global address is not a MqttAddress!");
        }
        this.ownAddress = (MqttAddress)this.ownAddressInjected;
        if (!(this.replyToAddressInjected instanceof MqttAddress)) {
            throw new JoynrIllegalStateException("Reply-to address is not a MqttAddress!");
        }
        this.replyToAddress = (MqttAddress)this.replyToAddressInjected;
        logger.debug("Created with sharedSubscriptionsEnabled: {} ownAddress: {} channelId: {} backendUid: {}", new Object[]{this.sharedSubscriptionsEnabled, this.ownAddress, this.channelId, this.backendUid});
    }

    public IMessagingSkeletonFactory get() {
        if (this.sharedSubscriptionsEnabled) {
            return this.createSharedSubscriptionsFactory();
        }
        return this.createFactory();
    }

    protected IMessagingSkeletonFactory createSharedSubscriptionsFactory() {
        return new SharedSubscriptionsMqttMessagingSkeletonFactory(this.gbids, this.ownAddress, this.replyToAddress, this.messageRouter, this.messageProcessedHandler, this.mqttClientFactory, this.channelId, this.mqttTopicPrefixProvider, this.rawMessagingPreprocessor, this.messageProcessors, this.routingTable, this.separateMqttReplyReceiver, this.backendUid, this.mqttMessageInProgressObserver);
    }

    protected IMessagingSkeletonFactory createFactory() {
        return new MqttMessagingSkeletonFactory(this.gbids, this.ownAddress, this.messageRouter, this.messageProcessedHandler, this.mqttClientFactory, this.mqttTopicPrefixProvider, this.rawMessagingPreprocessor, this.messageProcessors, this.routingTable, this.backendUid, this.mqttMessageInProgressObserver);
    }
}

