/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessagingSkeletonFactory;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.mqtt.DefaultMqttClientIdProvider;
import io.joynr.messaging.mqtt.DefaultMqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.MqttCiphersuiteListFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.MqttMessagingSkeletonProvider;
import io.joynr.messaging.mqtt.MqttMessagingStubFactory;
import io.joynr.messaging.mqtt.MqttMulticastAddressCalculator;
import io.joynr.messaging.mqtt.MqttMultipleBackendPropertyProvider;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttModule
extends AbstractModule {
    public static final String PROPERTY_KEY_MQTT_RECONNECT_SLEEP_MS = "joynr.messaging.mqtt.reconnect.sleepms";
    public static final String PROPERTY_MQTT_BROKER_URIS = "joynr.messaging.mqtt.brokeruris";
    public static final String MQTT_BROKER_URI_ARRAY = "joynr.internal.messaging.mqtt.brokeruriarray";
    public static final String MQTT_GBID_TO_BROKERURI_MAP = "joynr.internal.messaging.mqtt.gbidtobrokerurimap";
    public static final String PROPERTY_KEY_MQTT_CLIENT_ID_PREFIX = "joynr.messaging.mqtt.clientidprefix";
    public static final String PROPERTY_KEY_MQTT_KEEP_ALIVE_TIMERS_SEC = "joynr.messaging.mqtt.keepalivetimerssec";
    public static final String MQTT_TO_KEEP_ALIVE_TIMER_SEC_MAP = "joynr.internal.messaging.mqtt.gbidtokeepalivetimersecmap";
    public static final String PROPERTY_KEY_MQTT_CONNECTION_TIMEOUTS_SEC = "joynr.messaging.mqtt.connectiontimeoutssec";
    public static final String MQTT_GBID_TO_CONNECTION_TIMEOUT_SEC_MAP = "joynr.internal.messaging.mqtt.gbidtoconnectiontimeoutsecmap";
    public static final String PROPERTY_KEY_MQTT_KEYSTORE_PATH = "joynr.messaging.mqtt.ssl.keystore";
    public static final String PROPERTY_KEY_MQTT_TRUSTSTORE_PATH = "joynr.messaging.mqtt.ssl.truststore";
    public static final String PROPERTY_KEY_MQTT_KEYSTORE_TYPE = "joynr.messaging.mqtt.ssl.keystoretype";
    public static final String PROPERTY_KEY_MQTT_TRUSTSTORE_TYPE = "joynr.messaging.mqtt.ssl.truststoretype";
    public static final String PROPERTY_KEY_MQTT_KEYSTORE_PWD = "joynr.messaging.mqtt.ssl.keystorepassword";
    public static final String PROPERTY_KEY_MQTT_TRUSTSTORE_PWD = "joynr.messaging.mqtt.ssl.truststorepassword";
    public static final String PROPERTY_KEY_MQTT_CIPHERSUITES = "joynr.messaging.mqtt.ssl.ciphersuites";
    public static final String MQTT_CIPHERSUITE_LIST = "joynr.internal.messaging.mqtt.ssl.ciphersuiteList";
    public static final String PROPERTY_KEY_MQTT_SEPARATE_CONNECTIONS = "joynr.messaging.mqtt.separateconnections";
    public static final String PROPERTY_KEY_MQTT_USERNAME = "joynr.messaging.mqtt.username";
    public static final String PROPERTY_KEY_MQTT_PASSWORD = "joynr.messaging.mqtt.password";
    public static final String PROPERTY_KEY_MQTT_DISABLE_HOSTNAME_VERIFICATION = "joynr.messaging.mqtt.disablehostnameverification";
    public static final String PROPERTY_KEY_MQTT_RECEIVE_MAXIMUM = "joynr.messaging.mqtt.receivemaximum";
    public static final String PROPERTY_KEY_MQTT_CONNECT_ON_START = "joynr.messaging.mqtt.connectonstart";
    public static final String PROPERTY_KEY_MQTT_RETAIN = "joynr.messaging.mqtt.retain";
    public static final String PROPERTY_KEY_MQTT_ENABLE_SHARED_SUBSCRIPTIONS = "joynr.messaging.mqtt.enable.sharedsubscriptions";
    public static final String PROPERTY_MQTT_CLEAN_SESSION = "joynr.messaging.mqtt.cleansession";

    @Provides
    @Named(value="property_mqtt_global_address")
    public Address provideMqttOwnAddress(@Named(value="joynr.internal.messaging.gbidArray") String[] gbids, @Named(value="joynr.messaging.channelid") String localChannelId, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        return new MqttAddress(gbids[0], mqttTopicPrefixProvider.getUnicastTopicPrefix() + localChannelId);
    }

    @Provides
    @Named(value="property_mqtt_reply_to_address")
    public Address provideMqttOwnReplyToAddress(@Named(value="joynr.internal.messaging.gbidArray") String[] gbids, @Named(value="joynr.messaging.channelid") String localChannelId, @Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") String enableSharedSubscriptions, @Named(value="joynr.messaging.receiverid") String receiverId, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        String replyToTopic = Boolean.valueOf(enableSharedSubscriptions) != false ? mqttTopicPrefixProvider.getSharedSubscriptionsReplyToTopicPrefix() + localChannelId + "/" + receiverId : mqttTopicPrefixProvider.getUnicastTopicPrefix() + localChannelId;
        return new MqttAddress(gbids[0], replyToTopic);
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.gbidtobrokerurimap")
    public HashMap<String, String> provideGbidToBrokerUriMap(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideGbidToBrokerUriMap();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.brokeruriarray")
    public String[] provideMqttBrokerUriArray(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideBrokerUris();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.gbidtokeepalivetimersecmap")
    public HashMap<String, Integer> provideGbidTpKeepAliveTimerSecMap(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideGbidToKeepAliveTimerSecMap();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.gbidtoconnectiontimeoutsecmap")
    public HashMap<String, Integer> provideGbidToConnectionTimeoutSecMap(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideGbidToConnectionTimeoutSecMap();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.ssl.ciphersuiteList")
    public List<String> provideMqttInternalCipherList(MqttCiphersuiteListFactory internalCipherListFactory) {
        return internalCipherListFactory.create();
    }

    @Provides
    @Named(value="joynr.messaging.separatereplyreceiver")
    public boolean provideSeparateReplyReceiverSetting(@Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") boolean enableSharedSubscriptions) {
        return enableSharedSubscriptions;
    }

    protected void configure() {
        MapBinder messagingStubFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_STUB_FACTORIES"));
        messagingStubFactory.addBinding(MqttAddress.class).to(MqttMessagingStubFactory.class);
        MapBinder messagingSkeletonFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<IMessagingSkeletonFactory>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_SKELETON_FACTORIES"));
        messagingSkeletonFactory.addBinding(MqttAddress.class).toProvider(MqttMessagingSkeletonProvider.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), MulticastAddressCalculator.class).setBinding().to(MqttMulticastAddressCalculator.class);
        this.bind(MqttClientIdProvider.class).to(DefaultMqttClientIdProvider.class);
        this.bind(MqttTopicPrefixProvider.class).to(DefaultMqttTopicPrefixProvider.class);
    }
}

