/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.paho.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.paho.client.MqttPahoClient;
import io.joynr.messaging.mqtt.statusmetrics.MqttStatusReceiver;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.util.concurrent.ScheduledExecutorService;
import joynr.system.RoutingTypes.MqttAddress;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttPahoClientFactory
implements MqttClientFactory,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttPahoClientFactory.class);
    private MqttAddress ownAddress;
    private JoynrMqttClient mqttClient1 = null;
    private JoynrMqttClient mqttClient2 = null;
    private int reconnectSleepMs;
    private int keepAliveTimerSec;
    private int connectionTimeoutSec;
    private int timeToWaitMs;
    private int maxMsgsInflight;
    private int maxMsgSizeBytes;
    private ScheduledExecutorService scheduledExecutorService;
    private MqttClientIdProvider clientIdProvider;
    private MqttStatusReceiver mqttStatusReceiver;
    private boolean cleanSession;
    private boolean separateConnections;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystore")
    private String keyStorePath = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststore")
    private String trustStorePath = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystoretype")
    private String keyStoreType = "JKS";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststoretype")
    private String trustStoreType = "JKS";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystorepassword")
    private String keyStorePWD = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststorepassword")
    private String trustStorePWD = "";

    @Inject
    public MqttPahoClientFactory(@Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="joynr.messaging.mqtt.reconnect.sleepms") int reconnectSleepMs, @Named(value="joynr.messaging.mqtt.keepalivetimersec") int keepAliveTimerSec, @Named(value="joynr.messaging.mqtt.connectiontimeoutsec") int connectionTimeoutSec, @Named(value="joynr.messaging.mqtt.timetowaitms") int timeToWaitMs, @Named(value="joynr.messaging.mqtt.maxmsgsinflight") int maxMsgsInflight, @Named(value="joynr.messaging.mqtt.maxmqttmessagesizebytes") int maxMsgSizeBytes, @Named(value="joynr.messaging.mqtt.cleansession") boolean cleanSession, @Named(value="joynr.messaging.mqtt.separateconnections") boolean separateConnections, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduledExecutorService, MqttClientIdProvider mqttClientIdProvider, MqttStatusReceiver mqttStatusReceiver, ShutdownNotifier shutdownNotifier) {
        this.ownAddress = ownAddress;
        this.reconnectSleepMs = reconnectSleepMs;
        this.scheduledExecutorService = scheduledExecutorService;
        this.clientIdProvider = mqttClientIdProvider;
        this.mqttStatusReceiver = mqttStatusReceiver;
        this.keepAliveTimerSec = keepAliveTimerSec;
        this.connectionTimeoutSec = connectionTimeoutSec;
        this.timeToWaitMs = timeToWaitMs;
        this.maxMsgsInflight = maxMsgsInflight;
        this.maxMsgSizeBytes = maxMsgSizeBytes;
        this.cleanSession = cleanSession;
        this.separateConnections = separateConnections;
        shutdownNotifier.registerForShutdown((ShutdownListener)this);
    }

    @Override
    public synchronized JoynrMqttClient createReceiver() {
        if (this.mqttClient1 == null) {
            if (this.separateConnections) {
                this.mqttClient1 = this.createInternal(true, "Sub");
            } else {
                this.createCombinedClient();
            }
        }
        return this.mqttClient1;
    }

    @Override
    public synchronized JoynrMqttClient createSender() {
        if (this.mqttClient2 == null) {
            if (this.separateConnections) {
                this.mqttClient2 = this.createInternal(false, "Pub");
            } else {
                this.createCombinedClient();
            }
        }
        return this.mqttClient2;
    }

    public synchronized void shutdown() {
        this.mqttClient1.shutdown();
        if (this.separateConnections) {
            this.mqttClient2.shutdown();
        }
    }

    private void createCombinedClient() {
        this.mqttClient1 = this.mqttClient2 = this.createInternal(true, "");
    }

    private JoynrMqttClient createInternal(boolean isReceiver, String clientIdSuffix) {
        MqttPahoClient pahoClient = null;
        try {
            logger.debug("Create Mqtt Client. Address: {}", (Object)this.ownAddress);
            String clientId = this.clientIdProvider.getClientId() + clientIdSuffix;
            MqttClient mqttClient = new MqttClient(this.ownAddress.getBrokerUri(), clientId, (MqttClientPersistence)new MemoryPersistence(), this.scheduledExecutorService);
            logger.info("Creating MQTT Paho client using MQTT client ID: {}", (Object)clientId);
            pahoClient = new MqttPahoClient(mqttClient, this.reconnectSleepMs, this.keepAliveTimerSec, this.connectionTimeoutSec, this.timeToWaitMs, this.maxMsgsInflight, this.maxMsgSizeBytes, this.cleanSession, isReceiver, this.separateConnections, this.keyStorePath, this.trustStorePath, this.keyStoreType, this.trustStoreType, this.keyStorePWD, this.trustStorePWD, this.mqttStatusReceiver);
        }
        catch (MqttException e) {
            logger.error("Create MqttClient failed", (Throwable)e);
        }
        return pahoClient;
    }
}

