/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.GlobalAddressFactory;
import javax.inject.Named;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttReplyToAddressFactory
extends GlobalAddressFactory<MqttAddress> {
    private static final String SUPPORTED_TRANSPORT_MQTT = "mqtt";
    private String replyToTopic;
    private String brokerUri;

    @Inject
    public MqttReplyToAddressFactory(@Named(value="property_mqtt_global_address") MqttAddress globalAddress, @Named(value="joynr.messaging.channelid") String localChannelId, @Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") String enableSharedSubscriptions, @Named(value="joynr.messaging.receiverid") String receiverId, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        this.brokerUri = globalAddress.getBrokerUri();
        this.replyToTopic = Boolean.valueOf(enableSharedSubscriptions) != false ? mqttTopicPrefixProvider.getSharedSubscriptionsReplyToTopicPrefix() + localChannelId + "/" + receiverId : globalAddress.getTopic();
    }

    public MqttAddress create() {
        return new MqttAddress(this.brokerUri, this.replyToTopic);
    }

    public boolean supportsTransport(String transport) {
        return SUPPORTED_TRANSPORT_MQTT.equals(transport);
    }
}

