/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttCiphersuiteListFactory {
    private static final Logger logger = LoggerFactory.getLogger(MqttCiphersuiteListFactory.class);
    private List<String> cipherList;

    @Inject
    public MqttCiphersuiteListFactory(@Named(value="joynr.messaging.mqtt.ssl.ciphersuites") String cipherListString) {
        if (cipherListString.isEmpty()) {
            this.cipherList = new ArrayList<String>();
            return;
        }
        List tempCipherList = Arrays.stream(cipherListString.split(",")).map(a -> a.trim()).collect(Collectors.toList());
        if (tempCipherList.size() == 0) {
            String errorMsg = "Cipher list has no entries. This shouldn't be possible!";
            logger.error(errorMsg);
            throw new JoynrIllegalStateException(errorMsg);
        }
        for (String cipher : tempCipherList) {
            if (!cipher.isEmpty()) continue;
            String errorMsg = "Cipher must not be empty!";
            logger.error(errorMsg);
            throw new JoynrIllegalStateException(errorMsg);
        }
        this.cipherList = tempCipherList;
    }

    public List<String> create() {
        return this.cipherList;
    }
}

