/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.IMessagingSkeletonFactory;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeletonFactory;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.SharedSubscriptionsMqttMessagingSkeletonFactory;
import io.joynr.messaging.mqtt.statusmetrics.MqttStatusReceiver;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.ReplyToAddressRegistrar;
import java.util.Set;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingSkeletonProvider
implements Provider<IMessagingSkeletonFactory> {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingSkeletonProvider.class);
    protected MqttClientFactory mqttClientFactory;
    private boolean sharedSubscriptionsEnabled;
    private MqttAddress ownAddress;
    private int maxIncomingMqttRequests;
    private boolean backpressureEnabled;
    private int backpressureIncomingMqttRequestsUpperThreshold;
    private int backpressureIncomingMqttRequestsLowerThreshold;
    private MqttAddress replyToAddress;
    private MessageRouter messageRouter;
    private ReplyToAddressRegistrar replyToAddressRegistrar;
    private String channelId;
    private MqttTopicPrefixProvider mqttTopicPrefixProvider;
    private RawMessagingPreprocessor rawMessagingPreprocessor;
    private Set<JoynrMessageProcessor> messageProcessors;
    private MqttStatusReceiver mqttStatusReceiver;
    protected final String[] gbids;

    @Inject
    public MqttMessagingSkeletonProvider(@Named(value="joynr.internal.messaging.gbidArray") String[] gbids, @Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") boolean enableSharedSubscriptions, @Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="joynr.messaging.maxincomingmqttrequests") int maxIncomingMqttRequests, @Named(value="joynr.messaging.backpressure.enabled") boolean backpressureEnabled, @Named(value="joynr.messaging.backpressure.incomingmqttrequests.upperthreshold") int backpressureIncomingMqttRequestsUpperThreshold, @Named(value="joynr.messaging.backpressure.incomingmqttrequests.lowerthreshold") int backpressureIncomingMqttRequestsLowerThreshold, @Named(value="property_mqtt_reply_to_address") MqttAddress replyToAddress, MessageRouter messageRouter, ReplyToAddressRegistrar replyToAddressRegistrar, MqttClientFactory mqttClientFactory, @Named(value="joynr.messaging.channelid") String channelId, MqttTopicPrefixProvider mqttTopicPrefixProvider, RawMessagingPreprocessor rawMessagingPreprocessor, Set<JoynrMessageProcessor> messageProcessors, MqttStatusReceiver mqttStatusReceiver) {
        this.sharedSubscriptionsEnabled = enableSharedSubscriptions;
        this.rawMessagingPreprocessor = rawMessagingPreprocessor;
        this.messageProcessors = messageProcessors;
        this.ownAddress = ownAddress;
        this.maxIncomingMqttRequests = maxIncomingMqttRequests;
        this.backpressureEnabled = backpressureEnabled;
        this.backpressureIncomingMqttRequestsUpperThreshold = backpressureIncomingMqttRequestsUpperThreshold;
        this.backpressureIncomingMqttRequestsLowerThreshold = backpressureIncomingMqttRequestsLowerThreshold;
        this.replyToAddress = replyToAddress;
        this.messageRouter = messageRouter;
        this.replyToAddressRegistrar = replyToAddressRegistrar;
        this.mqttClientFactory = mqttClientFactory;
        this.channelId = channelId;
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
        this.mqttStatusReceiver = mqttStatusReceiver;
        this.gbids = (String[])gbids.clone();
        logger.debug("Created with sharedSubscriptionsEnabled: {} ownAddress: {} channelId: {}", new Object[]{this.sharedSubscriptionsEnabled, this.ownAddress, this.channelId});
    }

    public IMessagingSkeletonFactory get() {
        if (this.sharedSubscriptionsEnabled) {
            return new SharedSubscriptionsMqttMessagingSkeletonFactory(this.gbids, this.ownAddress, this.maxIncomingMqttRequests, this.backpressureEnabled, this.backpressureIncomingMqttRequestsUpperThreshold, this.backpressureIncomingMqttRequestsLowerThreshold, this.replyToAddress, this.messageRouter, this.replyToAddressRegistrar, this.mqttClientFactory, this.channelId, this.mqttTopicPrefixProvider, this.rawMessagingPreprocessor, this.messageProcessors, this.mqttStatusReceiver);
        }
        return new MqttMessagingSkeletonFactory(this.gbids, this.ownAddress, this.maxIncomingMqttRequests, this.messageRouter, this.replyToAddressRegistrar, this.mqttClientFactory, this.mqttTopicPrefixProvider, this.rawMessagingPreprocessor, this.messageProcessors, this.mqttStatusReceiver);
    }
}

