/*
 * Decompiled with CFR 0.152.
 */
package io.joynr;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.runtime.AbstractJoynrInjectorFactory;
import io.joynr.runtime.AcceptsMessageReceiver;
import io.joynr.runtime.JoynrApplication;
import io.joynr.runtime.JoynrApplicationModule;
import io.joynr.runtime.MessageReceiverType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrApplicationLauncher {
    private static final Logger logger = LoggerFactory.getLogger(JoynrApplicationLauncher.class);
    private ExecutorService executionQueue;
    private List<JoynrApplication> apps = new ArrayList<JoynrApplication>();
    private static final long timeout = 20L;
    private Injector joynrInjector;

    public void init(Properties properties, Set<Class<? extends JoynrApplication>> joynrApplicationsClasses, AbstractJoynrInjectorFactory injectorFactory, Module ... modules) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, r.getClass().getSimpleName());
            }
        };
        this.executionQueue = Executors.newCachedThreadPool(threadFactory);
        try {
            injectorFactory.updateInjectorModule(properties, modules);
            this.joynrInjector = injectorFactory.getInjector();
            for (Class<? extends JoynrApplication> appClass : joynrApplicationsClasses) {
                MessageReceiverType messageReceiverType;
                if (Modifier.isAbstract(appClass.getModifiers())) continue;
                AcceptsMessageReceiver acceptsMessageReceiverAnnotation = appClass.getAnnotation(AcceptsMessageReceiver.class);
                MessageReceiverType messageReceiverType2 = messageReceiverType = acceptsMessageReceiverAnnotation == null ? MessageReceiverType.ANY : appClass.getAnnotation(AcceptsMessageReceiver.class).value();
                if (messageReceiverType.equals((Object)MessageReceiverType.SERVLET)) continue;
                logger.info("Running app: " + appClass.getName());
                JoynrApplication app = injectorFactory.createApplication(new JoynrApplicationModule(appClass), new Module[0]);
                this.apps.add(app);
                this.executionQueue.submit((Runnable)app);
            }
        }
        catch (RuntimeException e) {
            logger.error("ERROR", (Throwable)e);
            throw e;
        }
    }

    public void shutdown(boolean clear) {
        if (this.executionQueue != null) {
            this.executionQueue.shutdownNow();
        }
        if (this.joynrInjector != null) {
            ServletMessageReceiver servletReceiver = (ServletMessageReceiver)this.joynrInjector.getInstance(ServletMessageReceiver.class);
            servletReceiver.switchToLongPolling();
            for (JoynrApplication app : this.apps) {
                try {
                    app.shutdown();
                }
                catch (Exception e) {
                    logger.debug("error shutting down app: " + app.getClass(), (Throwable)e);
                }
            }
            servletReceiver.shutdown(clear);
        }
        try {
            if (this.executionQueue != null) {
                this.executionQueue.awaitTermination(20L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public Injector getJoynrInjector() {
        return this.joynrInjector;
    }
}

