/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.guice.servlet;

import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.core.spi.scanning.PackageNamesScanner;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.scanning.AnnotationScannerListener;
import io.joynr.runtime.PropertyLoader;
import io.joynr.servlet.DefaultServletWrapper;
import java.util.Arrays;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJoynrServletModule
extends JerseyServletModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJoynrServletModule.class);
    private static final String IO_JOYNR_APPS_PACKAGES = "io.joynr.apps.packages";

    protected final void configureServlets() {
        this.bind(GuiceFilter.class);
        this.configureJoynrServlets();
        this.bindStaticWebResources();
        this.bindJoynrServletClass();
        this.bindAnnotatedFilters();
    }

    protected void bindStaticWebResources() {
        this.bind(DefaultServletWrapper.class);
        this.serve("*.html", new String[]{"*.htm", "*.js", "*.jpg", "*.png", "*.css"}).with(DefaultServletWrapper.class);
    }

    protected void bindJoynrServletClass() {
        this.serve("/*", new String[0]).with(GuiceContainer.class);
    }

    protected abstract void configureJoynrServlets();

    private void bindAnnotatedFilters() {
        String appsPackages = null;
        if (System.getProperties().containsKey(IO_JOYNR_APPS_PACKAGES)) {
            logger.info("Using property {} from system properties", (Object)IO_JOYNR_APPS_PACKAGES);
            appsPackages = System.getProperty(IO_JOYNR_APPS_PACKAGES);
        } else {
            Properties servletProperties = PropertyLoader.loadProperties((String)"servlet.properties");
            if (servletProperties.containsKey(IO_JOYNR_APPS_PACKAGES)) {
                appsPackages = servletProperties.getProperty(IO_JOYNR_APPS_PACKAGES);
            }
        }
        if (appsPackages != null) {
            Object[] packageNames = appsPackages.split(";");
            logger.info("Searching packages for @WebFilter annotation: {}", (Object)Arrays.toString(packageNames));
            PackageNamesScanner scanner = new PackageNamesScanner((String[])packageNames);
            AnnotationScannerListener sl = new AnnotationScannerListener(new Class[]{WebFilter.class});
            scanner.scan((ScannerListener)sl);
            for (Class webFilterAnnotatedClass : sl.getAnnotatedClasses()) {
                if (!Filter.class.isAssignableFrom(webFilterAnnotatedClass)) continue;
                this.bind(webFilterAnnotatedClass).in(Singleton.class);
                this.filter("/*", new String[0]).through(webFilterAnnotatedClass);
                logger.info("Adding filter {} for '/*'", (Object)webFilterAnnotatedClass.getName());
            }
        }
    }
}

