/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.http.HttpGlobalAddressFactory;

public class ServletHttpGlobalAddressFactory
extends HttpGlobalAddressFactory {
    private static final String SUPPORTED_TRANSPORT_SERVLET = "servlet";
    private String hostPath;
    private String contextRoot;
    private String myChannelId;

    @Inject
    public ServletHttpGlobalAddressFactory(@Named(value="joynr.servlet.hostpath") String hostPath, @Named(value="joynr.servlet.context.root") String contextRoot, @Named(value="joynr.messaging.channelid") String myChannelId) {
        if (hostPath.endsWith("/")) {
            hostPath = hostPath.substring(0, hostPath.length() - 1);
        }
        this.hostPath = hostPath;
        this.contextRoot = contextRoot;
        this.myChannelId = myChannelId;
    }

    protected String getMyChannelId() {
        return this.myChannelId;
    }

    protected String getMessagingEndpointUrl() {
        return this.hostPath + this.contextRoot + "/channels/" + this.myChannelId + "/";
    }

    public boolean supportsTransport(String transport) {
        return SUPPORTED_TRANSPORT_SERVLET.equalsIgnoreCase(transport);
    }
}

