/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtil {
    private static final Logger logger = LoggerFactory.getLogger(ServletUtil.class);

    public static Properties loadProperties(String filename, ServletContext servletContext) {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = servletContext.getResourceAsStream("/WEB-INF/" + filename);
            if (in == null) {
                logger.error("properties file not found");
            } else {
                properties.load(in);
            }
        }
        catch (IOException e) {
            logger.error("properties file not loaded", (Throwable)e);
        }
        return properties;
    }

    public static int findFreePort() throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
    }
}

