/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.websocket.jetty.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.joynr.exceptions.JoynrCommunicationException;
import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrMessageExpiredException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.SuccessAction;
import io.joynr.messaging.websocket.IWebSocketMessagingSkeleton;
import io.joynr.messaging.websocket.JoynrWebSocketEndpoint;
import io.joynr.messaging.websocket.MessageHelper;
import io.joynr.util.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.exceptions.WebSocketException;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketJettyClient
extends WebSocketAdapter
implements JoynrWebSocketEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketJettyClient.class);
    private Timer reconnectTimer = new Timer();
    private AtomicBoolean reconnectTimerRunning = new AtomicBoolean(false);
    private long reconnectDelay;
    private WebSocketClient jettyClient;
    private int maxMessageSize;
    private long websocketIdleTimeout;
    CompletableFuture<Session> sessionFuture;
    private WebSocketAddress serverAddress;
    private IWebSocketMessagingSkeleton messageListener;
    private ObjectMapper objectMapper;
    private WebSocketClientAddress ownAddress;
    private boolean shutdown = false;

    public WebSocketJettyClient(WebSocketAddress serverAddress, WebSocketClientAddress ownAddress, int maxMessageSize, long reconnectDelay, long websocketIdleTimeout, ObjectMapper objectMapper) {
        this.serverAddress = serverAddress;
        this.ownAddress = ownAddress;
        this.maxMessageSize = maxMessageSize;
        this.reconnectDelay = reconnectDelay;
        this.websocketIdleTimeout = websocketIdleTimeout;
        this.objectMapper = objectMapper;
    }

    public synchronized void start() {
        block6: {
            if (this.jettyClient == null) {
                this.jettyClient = new WebSocketClient();
                this.jettyClient.setMaxTextMessageSize((long)this.maxMessageSize);
                this.jettyClient.setMaxBinaryMessageSize((long)this.maxMessageSize);
                this.jettyClient.setIdleTimeout(Duration.ofMillis(this.websocketIdleTimeout));
            }
            try {
                logger.debug("Starting WebSocket client ...");
                this.jettyClient.start();
                URI toUri = this.toUrl(this.serverAddress);
                logger.debug("Connecting to {} ... ", (Object)toUri);
                this.sessionFuture = this.jettyClient.connect((Object)this, toUri);
                Session session = this.sessionFuture.get(30L, TimeUnit.SECONDS);
                logger.debug("WebSocket client connected");
                this.sendInitializationMessage(session);
            }
            catch (JoynrIllegalStateException | JoynrShutdownException e) {
                logger.error("Unrecoverable error starting WebSocket client: {}", e);
                return;
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted while start.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.debug("Error starting WebSocket client. Will retry", (Throwable)e);
                if (this.shutdown) {
                    return;
                }
                if (!this.reconnectTimerRunning.compareAndSet(false, true)) break block6;
                this.reconnectTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        WebSocketJettyClient.this.reconnectTimerRunning.set(false);
                        WebSocketJettyClient.this.start();
                    }
                }, this.reconnectDelay);
            }
        }
    }

    private void sendInitializationMessage(Session session) throws JoynrCommunicationException {
        String serializedAddress;
        try {
            serializedAddress = this.objectMapper.writeValueAsString((Object)this.ownAddress);
        }
        catch (JsonProcessingException e) {
            throw new JoynrIllegalStateException("unable to serialize WebSocket Client address: " + this.ownAddress, (Exception)((Object)e));
        }
        try {
            session.getRemote().sendBytes(ByteBuffer.wrap(serializedAddress.getBytes(CHARSET)));
        }
        catch (IOException e) {
            throw new JoynrCommunicationException(e.getMessage(), (Throwable)e);
        }
    }

    private URI toUrl(WebSocketAddress address) {
        try {
            return URI.create(address.getProtocol() + "://" + address.getHost() + ":" + address.getPort() + address.getPath());
        }
        catch (IllegalArgumentException e) {
            throw new JoynrIllegalStateException("unable to parse WebSocket Server Address", (Exception)e);
        }
    }

    public void setMessageListener(IWebSocketMessagingSkeleton messaging) {
        this.messageListener = messaging;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.closeSession();
        try {
            if (this.jettyClient != null) {
                this.jettyClient.stop();
            }
        }
        catch (Exception e) {
            logger.error("Error stopping WebSocket client: ", (Throwable)e);
        }
    }

    private void closeSession() {
        try {
            if (this.sessionFuture != null) {
                Session session = this.sessionFuture.get();
                if (session != null) {
                    session.close();
                }
                this.sessionFuture = null;
            }
        }
        catch (InterruptedException ex) {
            logger.error("Thread interrupted while closing session.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Error while closing websocket connection: ", (Throwable)e);
        }
    }

    public synchronized void reconnect() {
        try {
            if (this.sessionFuture != null && this.sessionFuture.get().isOpen()) {
                return;
            }
        }
        catch (ExecutionException e) {
            logger.debug("Error getting session future", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.shutdown) {
            return;
        }
        this.closeSession();
        this.start();
    }

    public void onWebSocketText(String message) {
        logger.error("Received text Message: {}", (Object)message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        byte[] message = MessageHelper.extractMessage((byte[])payload, (int)offset, (int)len);
        if (logger.isTraceEnabled()) {
            logger.trace("Received message: {}", (Object)new String(message, CHARSET));
        }
        this.messageListener.transmit(message, error -> {
            if (error instanceof JoynrMessageExpiredException) {
                logger.warn("WebSocket message not processed: ", error);
            } else {
                logger.error("WebSocket message not processed: ", error);
            }
        });
    }

    public synchronized void writeBytes(Address to, byte[] message, long timeout, TimeUnit unit, final SuccessAction successAction, final FailureAction failureAction) {
        if (this.messageListener == null) {
            throw new JoynrDelayMessageException(20L, "WebSocket write failed: receiver has not been set yet");
        }
        if (this.sessionFuture == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                throw new JoynrDelayMessageException(10L, "WebSocket reconnect failed. Will try later", (Throwable)e);
            }
        }
        try {
            Session session = this.sessionFuture.get(timeout, unit);
            session.getRemote().sendBytes(ByteBuffer.wrap(message), new WriteCallback(){

                public void writeSuccess() {
                    successAction.execute();
                }

                public void writeFailed(Throwable error) {
                    if (error instanceof WebSocketException) {
                        WebSocketJettyClient.this.reconnect();
                        failureAction.execute((Throwable)new JoynrDelayMessageException(WebSocketJettyClient.this.reconnectDelay, error.getMessage()));
                    } else {
                        failureAction.execute(error);
                    }
                }
            });
        }
        catch (ExecutionException | WebSocketException e) {
            this.reconnect();
            throw new JoynrDelayMessageException(10L, "WebSocket write failed", e);
        }
        catch (TimeoutException e) {
            throw new JoynrDelayMessageException("WebSocket write timed out", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        if (!this.shutdown) {
            this.reconnect();
        }
    }
}

