/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.websocket.jetty.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.websocket.JoynrWebSocketEndpoint;
import io.joynr.messaging.websocket.WebSocketEndpointFactory;
import io.joynr.messaging.websocket.jetty.client.WebSocketJettyClient;
import io.joynr.util.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;

@Singleton
public class WebSocketJettyClientFactory
implements WebSocketEndpointFactory {
    private WebSocketClientAddress ownAddress;
    private int maxMessageSize;
    private long reconnectDelay;
    private long websocketIdleTimeout;
    private Map<WebSocketAddress, JoynrWebSocketEndpoint> jettyClientsMap = new HashMap<WebSocketAddress, JoynrWebSocketEndpoint>();
    private ObjectMapper objectMapper;

    @Inject
    public WebSocketJettyClientFactory(@Named(value="websocket_client_address") WebSocketClientAddress ownAddress, @Named(value="joynr.messaging.maxmessagesize") int maxMessageSize, @Named(value="joynr.messaging.cc.reconnectdelay") long reconnectDelay, @Named(value="joynr.messaging.cc.idletimeout") long websocketIdleTimeout, ObjectMapper objectMapper) {
        this.ownAddress = ownAddress;
        this.maxMessageSize = maxMessageSize;
        this.reconnectDelay = reconnectDelay;
        this.websocketIdleTimeout = websocketIdleTimeout;
        this.objectMapper = objectMapper;
    }

    public synchronized JoynrWebSocketEndpoint create(WebSocketAddress serverAddress) {
        if (!this.jettyClientsMap.containsKey(serverAddress)) {
            WebSocketJettyClient jettyClient = new WebSocketJettyClient(serverAddress, this.ownAddress, this.maxMessageSize, this.reconnectDelay, this.websocketIdleTimeout, this.objectMapper);
            this.jettyClientsMap.put(serverAddress, jettyClient);
        }
        return this.jettyClientsMap.get(serverAddress);
    }
}

