/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME;
    private static final Logger log;
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private MqttCallbackExtended reconnectInternalCallback;
    private Hashtable callbacks;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    private boolean manualAcks = false;
    private String threadName;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private Future callbackFuture;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.paho.client.mqttv3.internal.CommsCallback");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    }

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        this.callbacks = new Hashtable();
        log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.callbackFuture != null) {
                this.callbackFuture.cancel(true);
            }
            if (this.running) {
                log.fine(CLASS_NAME, "stop", "700");
                this.running = false;
                if (!Thread.currentThread().equals(this.callbackThread)) {
                    try {
                        try {
                            Object object2 = this.workAvailable;
                            synchronized (object2) {
                                log.fine(CLASS_NAME, "stop", "701");
                                this.workAvailable.notifyAll();
                            }
                            this.runningSemaphore.acquire();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        this.runningSemaphore.release();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        this.runningSemaphore.release();
                    }
                }
            }
            this.callbackThread = null;
            log.fine(CLASS_NAME, "stop", "703");
            return;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    public void setReconnectCallback(MqttCallbackExtended callback) {
        this.reconnectInternalCallback = callback;
    }

    public void setManualAcks(boolean manualAcks) {
        this.manualAcks = manualAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.callbackThread = Thread.currentThread();
        this.callbackThread.setName(this.threadName);
        try {
            this.runningSemaphore.acquire();
        }
        catch (InterruptedException v0) {
            this.running = false;
            return;
        }
        while (true) {
            if (!this.running) {
                return;
            }
            try {
                try {
                    try {
                        var1_1 = this.workAvailable;
                        synchronized (var1_1) {
                            if (this.running && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                                CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "704");
                                this.workAvailable.wait();
                            }
                        }
                    }
                    catch (InterruptedException v2) {}
                    if (this.running) {
                        token = null;
                        var2_3 = this.completeQueue;
                        synchronized (var2_3) {
                            if (!this.completeQueue.isEmpty()) {
                                token = (MqttToken)this.completeQueue.elementAt(0);
                                this.completeQueue.removeElementAt(0);
                            }
                        }
                        if (token != null) {
                            this.handleActionComplete(token);
                        }
                        message = null;
                        var3_4 = this.messageQueue;
                        synchronized (var3_4) {
                            if (!this.messageQueue.isEmpty()) {
                                message = (MqttPublish)this.messageQueue.elementAt(0);
                                this.messageQueue.removeElementAt(0);
                            }
                        }
                        if (message != null) {
                            this.handleMessage(message);
                        }
                    }
                    if (this.quiescing) {
                        this.clientState.checkQuiesceLock();
                    }
                }
                catch (Throwable ex) {
                    CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "714", null, ex);
                    this.running = false;
                    this.clientComms.shutdownConnection(null, new MqttException(ex));
                }
            }
            catch (Throwable var5_7) {
                var4_5 = null;
                this.runningSemaphore.release();
                var6_6 = this.spaceAvailable;
                synchronized (var6_6) {
                    CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                    throw var5_7;
                }
            }
            {
                var4_5 = null;
                this.runningSemaphore.release();
                var6_6 = this.spaceAvailable;
            }
            synchronized (var6_6) {
                ** try [egrp 7[TRYBLOCK] [11 : 304->333)] { 
lbl78:
                // 1 sources

                CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                this.spaceAvailable.notifyAll();
            }
        }
lbl-1000:
        // 1 sources

        {
            catch (Throwable v6) {
                throw v6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            log.fine(CLASS_NAME, "handleActionComplete", "705", new Object[]{token.internalTok.getKey()});
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token.isComplete() && (token instanceof MqttDeliveryToken || token.getActionCallback() instanceof IMqttActionListener)) {
                token.internalTok.setNotified(true);
            }
        }
    }

    public void connectionLost(MqttException cause) {
        try {
            if (this.mqttCallback != null && cause != null) {
                log.fine(CLASS_NAME, "connectionLost", "708", new Object[]{cause});
                this.mqttCallback.connectionLost(cause);
            }
            if (this.reconnectInternalCallback != null && cause != null) {
                this.reconnectInternalCallback.connectionLost(cause);
            }
        }
        catch (Throwable t) {
            log.fine(CLASS_NAME, "connectionLost", "720", new Object[]{t});
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onSuccess(token);
            } else {
                log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageArrived(MqttPublish sendMessage) {
        if (this.mqttCallback == null) {
            if (this.callbacks.size() <= 0) return;
        }
        Object object = this.spaceAvailable;
        synchronized (object) {
            while (this.running && !this.quiescing && this.messageQueue.size() >= 10) {
                try {
                    log.fine(CLASS_NAME, "messageArrived", "709");
                    this.spaceAvailable.wait(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.quiescing) return;
        this.messageQueue.addElement(sendMessage);
        object = this.workAvailable;
        synchronized (object) {
            log.fine(CLASS_NAME, "messageArrived", "710");
            this.workAvailable.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            log.fine(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        String destName = publishMessage.getTopicName();
        log.fine(CLASS_NAME, "handleMessage", "713", new Object[]{new Integer(publishMessage.getMessageId()), destName});
        this.deliverMessage(destName, publishMessage.getMessageId(), publishMessage.getMessage());
        if (!this.manualAcks) {
            if (publishMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        if (qos == 1) {
            this.clientComms.internalSend(new MqttPubAck(messageId), new MqttToken(this.clientComms.getClient().getClientId()));
        } else if (qos == 2) {
            this.clientComms.deliveryComplete(messageId);
            MqttPubComp pubComp = new MqttPubComp(messageId);
            this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token) {
        if (this.running) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                log.fine(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{token.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            log.fine(CLASS_NAME, "asyncOperationComplete", "719", null, ex);
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    public void setMessageListener(String topicFilter, IMqttMessageListener messageListener) {
        this.callbacks.put(topicFilter, messageListener);
    }

    public void removeMessageListener(String topicFilter) {
        this.callbacks.remove(topicFilter);
    }

    public void removeMessageListeners() {
        this.callbacks.clear();
    }

    protected boolean deliverMessage(String topicName, int messageId, MqttMessage aMessage) throws Exception {
        boolean delivered = false;
        Enumeration keys = this.callbacks.keys();
        while (keys.hasMoreElements()) {
            String topicFilter = (String)keys.nextElement();
            if (!MqttTopic.isMatched(topicFilter, topicName)) continue;
            aMessage.setId(messageId);
            ((IMqttMessageListener)this.callbacks.get(topicFilter)).messageArrived(topicName, aMessage);
            delivered = true;
        }
        if (this.mqttCallback != null && !delivered) {
            aMessage.setId(messageId);
            this.mqttCallback.messageArrived(topicName, aMessage);
            delivered = true;
        }
        return delivered;
    }
}

