/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME;
    private static final Logger log;
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private volatile boolean receiving;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private String threadName;
    private Future receiverFuture;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.paho.client.mqttv3.internal.CommsReceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    }

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(clientState, in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        log.fine(CLASS_NAME, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.receiverFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.receiverFuture != null) {
                this.receiverFuture.cancel(true);
            }
            log.fine(CLASS_NAME, "stop", "850");
            if (this.running) {
                this.running = false;
                this.receiving = false;
                if (!Thread.currentThread().equals(this.recThread)) {
                    try {
                        try {
                            this.runningSemaphore.acquire();
                        }
                        catch (InterruptedException interruptedException) {}
                        Object var2_4 = null;
                        this.runningSemaphore.release();
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        this.runningSemaphore.release();
                        throw throwable;
                    }
                }
            }
        }
        this.recThread = null;
        log.fine(CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        token = null;
        try {
            this.runningSemaphore.acquire();
        }
        catch (InterruptedException v0) {
            this.running = false;
            return;
        }
        while (true) {
            if (!this.running || this.in == null) {
                CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "854");
                return;
            }
            try {
                try {
                    block15: {
                        CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "852");
                        this.receiving = this.in.available() > 0;
                        message = this.in.readMqttWireMessage();
                        this.receiving = false;
                        if (!(message instanceof MqttAck)) break block15;
                        token = this.tokenStore.getToken(message);
                        if (token == null) {
                            throw new MqttException(6);
                        }
                        var3_5 = token;
                        synchronized (var3_5) {
                            this.clientState.notifyReceivedAck((MqttAck)message);
                            ** GOTO lbl-1000
                        }
                    }
                    this.clientState.notifyReceivedMsg(message);
                }
                catch (MqttException ex) {
                    CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "856", null, ex);
                    this.running = false;
                    this.clientComms.shutdownConnection(token, ex);
                }
                catch (IOException ioe) {
                    CommsReceiver.log.fine(CommsReceiver.CLASS_NAME, "run", "853");
                    this.running = false;
                    if (!this.clientComms.isDisconnecting()) {
                        this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
                    }
                }
            }
            catch (Throwable var5_7) {
                var4_6 = null;
                this.receiving = false;
                this.runningSemaphore.release();
                throw var5_7;
            }
lbl-1000:
            // 4 sources

            {
                var4_6 = null;
                this.receiving = false;
                this.runningSemaphore.release();
                continue;
            }
            break;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }
}

