/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.ScheduledExecutorPingSender;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttClient
implements IMqttClient {
    protected MqttAsyncClient aClient = null;
    protected long timeToWait = -1L;

    public MqttClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this.aClient = new MqttAsyncClient(serverURI, clientId, persistence);
    }

    public MqttClient(String serverURI, String clientId, MqttClientPersistence persistence, ScheduledExecutorService executorService) throws MqttException {
        this.aClient = new MqttAsyncClient(serverURI, clientId, persistence, new ScheduledExecutorPingSender(executorService), executorService);
    }

    public void connect() throws MqttSecurityException, MqttException {
        this.connect(new MqttConnectOptions());
    }

    public void connect(MqttConnectOptions options) throws MqttSecurityException, MqttException {
        this.aClient.connect(options, null, null).waitForCompletion(this.getTimeToWait());
    }

    public IMqttToken connectWithResult(MqttConnectOptions options) throws MqttSecurityException, MqttException {
        IMqttToken tok = this.aClient.connect(options, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        return tok;
    }

    public void disconnect() throws MqttException {
        this.aClient.disconnect().waitForCompletion();
    }

    public void disconnect(long quiesceTimeout) throws MqttException {
        this.aClient.disconnect(quiesceTimeout, null, null).waitForCompletion();
    }

    public void disconnectForcibly() throws MqttException {
        this.aClient.disconnectForcibly();
    }

    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.aClient.disconnectForcibly(disconnectTimeout);
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.aClient.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    public void subscribe(String topicFilter) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{1});
    }

    public void subscribe(String[] topicFilters) throws MqttException {
        int[] qos = new int[topicFilters.length];
        int i = 0;
        while (i < qos.length) {
            qos[i] = 1;
            ++i;
        }
        this.subscribe(topicFilters, qos);
    }

    public void subscribe(String topicFilter, int qos) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{qos});
    }

    public void subscribe(String[] topicFilters, int[] qos) throws MqttException {
        IMqttToken tok = this.aClient.subscribe(topicFilters, qos, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        int[] grantedQos = tok.getGrantedQos();
        int i = 0;
        while (i < grantedQos.length) {
            qos[i] = grantedQos[i];
            ++i;
        }
        if (grantedQos.length == 1 && qos[0] == 128) {
            throw new MqttException(128);
        }
    }

    public void subscribe(String topicFilter, IMqttMessageListener messageListener) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{1}, new IMqttMessageListener[]{messageListener});
    }

    public void subscribe(String[] topicFilters, IMqttMessageListener[] messageListeners) throws MqttException {
        int[] qos = new int[topicFilters.length];
        int i = 0;
        while (i < qos.length) {
            qos[i] = 1;
            ++i;
        }
        this.subscribe(topicFilters, qos, messageListeners);
    }

    public void subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{qos}, new IMqttMessageListener[]{messageListener});
    }

    public void subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        this.subscribe(topicFilters, qos);
        int i = 0;
        while (i < topicFilters.length) {
            this.aClient.comms.setMessageListener(topicFilters[i], messageListeners[i]);
            ++i;
        }
    }

    public void unsubscribe(String topicFilter) throws MqttException {
        this.unsubscribe(new String[]{topicFilter});
    }

    public void unsubscribe(String[] topicFilters) throws MqttException {
        this.aClient.unsubscribe(topicFilters, null, null).waitForCompletion(this.getTimeToWait());
    }

    public void publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.publish(topic, message);
    }

    public void publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        this.aClient.publish(topic, message, null, null).waitForCompletion(this.getTimeToWait());
    }

    public void setTimeToWait(long timeToWaitInMillis) throws IllegalArgumentException {
        if (timeToWaitInMillis < -1L) {
            throw new IllegalArgumentException();
        }
        this.timeToWait = timeToWaitInMillis;
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    public void close() throws MqttException {
        this.aClient.close();
    }

    public String getClientId() {
        return this.aClient.getClientId();
    }

    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.aClient.getPendingDeliveryTokens();
    }

    public String getServerURI() {
        return this.aClient.getServerURI();
    }

    public String getCurrentServerURI() {
        return this.aClient.getCurrentServerURI();
    }

    public MqttTopic getTopic(String topic) {
        return this.aClient.getTopic(topic);
    }

    public boolean isConnected() {
        return this.aClient.isConnected();
    }

    public void setCallback(MqttCallback callback) {
        this.aClient.setCallback(callback);
    }

    public void setManualAcks(boolean manualAcks) {
        this.aClient.setManualAcks(manualAcks);
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.aClient.messageArrivedComplete(messageId, qos);
    }

    public static String generateClientId() {
        return MqttAsyncClient.generateClientId();
    }

    public void reconnect() throws MqttException {
        this.aClient.reconnect();
    }

    public Debug getDebug() {
        return this.aClient.getDebug();
    }
}

