/*
 * Decompiled with CFR 0.152.
 */
package joynr.tests.performance;

import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.proxy.Callback;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncResponseCounterCallback<type>
extends Callback<type> {
    private AtomicInteger responseCounter = new AtomicInteger(0);
    private AtomicInteger failureCounter = new AtomicInteger(0);

    public void onFailure(JoynrRuntimeException runtimeException) {
        this.responseCounter.incrementAndGet();
        this.failureCounter.incrementAndGet();
    }

    public void onSuccess(type result) {
        this.responseCounter.incrementAndGet();
    }

    public void waitForNumberOfResponses(int numExpectedResponses, int sleepIntervalMilliSec) {
        while (this.responseCounter.get() < numExpectedResponses) {
            try {
                Thread.sleep(sleepIntervalMilliSec);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean failuresOccured() {
        return this.failureCounter.get() > 0;
    }

    public int getNumberOfFailures() {
        return this.failureCounter.get();
    }

    public int getNumberOfRespones() {
        return this.responseCounter.get();
    }
}

