/*
 * Decompiled with CFR 0.152.
 */
package joynr.tests.performance;

import com.google.inject.Module;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.runtime.AbstractJoynrApplication;
import io.joynr.runtime.JoynrApplication;
import io.joynr.runtime.JoynrApplicationModule;
import io.joynr.runtime.JoynrInjectorFactory;
import io.joynr.runtime.LibjoynrWebSocketRuntimeModule;
import java.util.Arrays;
import java.util.Properties;
import jline.internal.Log;
import joynr.tests.performance.AsyncResponseCounterCallback;
import joynr.tests.performance.EchoProxy;
import joynr.tests.performance.PerformanceTestConsumerInvocationParameters;
import joynr.tests.performance.Types.ComplexStruct;

public class PerformanceTestConsumerApplication
extends AbstractJoynrApplication {
    private static final String STATIC_PERSISTENCE_FILE = "java-consumer.persistence_file";
    private static final int ASYNCTEST_RESPONSE_SAMPLEINTERVAL_MS = 10;
    private static PerformanceTestConsumerInvocationParameters invocationParameters = null;

    public static void main(String[] args) {
        try {
            invocationParameters = new PerformanceTestConsumerInvocationParameters(args);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(-1);
        }
        JoynrApplication consumerApp = PerformanceTestConsumerApplication.createConsumerApp(invocationParameters.getDomainName());
        consumerApp.run();
        consumerApp.shutdown();
    }

    private static JoynrApplication createConsumerApp(String domainName) {
        Properties appConfig = new Properties();
        appConfig.setProperty("inter-language-test.provider.domain", domainName);
        Properties joynrConfig = new Properties();
        joynrConfig.setProperty("joynr.messaging.cc.host", "localhost");
        joynrConfig.setProperty("joynr.messaging.cc.port", "4242");
        joynrConfig.setProperty("joynr.messaging.cc.protocol", "ws");
        joynrConfig.setProperty("joynr.messaging.cc.path", "");
        joynrConfig.setProperty("joynr.messaging.persistence_file", STATIC_PERSISTENCE_FILE);
        joynrConfig.setProperty("joynr.domain.local", "performance_test_consumer_local_domain");
        LibjoynrWebSocketRuntimeModule runtimeModule = new LibjoynrWebSocketRuntimeModule();
        return new JoynrInjectorFactory(joynrConfig, new Module[]{runtimeModule}).createApplication(new JoynrApplicationModule(PerformanceTestConsumerApplication.class, appConfig));
    }

    public void run() {
        EchoProxy echoProxy = this.createEchoProxy();
        if (invocationParameters.getCommunicationMode() == PerformanceTestConsumerInvocationParameters.COMMUNICATIONMODE.SYNC) {
            switch (invocationParameters.getTestCase()) {
                case SEND_STRING: {
                    this.performSyncSendStringTest(echoProxy);
                    break;
                }
                case SEND_STRUCT: {
                    this.performSyncSendStructTest(echoProxy);
                    break;
                }
                case SEND_BYTEARRAY: {
                    this.performSyncSendByteArrayTest(echoProxy);
                    break;
                }
                default: {
                    Log.error((Object[])new Object[]{"Unknown test type used"});
                    break;
                }
            }
        } else if (invocationParameters.getCommunicationMode() == PerformanceTestConsumerInvocationParameters.COMMUNICATIONMODE.ASYNC) {
            switch (invocationParameters.getTestCase()) {
                case SEND_STRING: {
                    this.performAsyncSendStringTest(echoProxy);
                    break;
                }
                case SEND_STRUCT: {
                    this.performAsyncSendStructTest(echoProxy);
                    break;
                }
                case SEND_BYTEARRAY: {
                    this.performAsyncSendByteArrayTest(echoProxy);
                    break;
                }
                default: {
                    Log.error((Object[])new Object[]{"Unknown test type used"});
                    break;
                }
            }
        } else {
            Log.error((Object[])new Object[]{"Unknown communication mode used"});
        }
    }

    private EchoProxy createEchoProxy() {
        DiscoveryQos discoveryQos = new DiscoveryQos();
        discoveryQos.setDiscoveryTimeout(100000L);
        discoveryQos.setCacheMaxAge(Long.MAX_VALUE);
        discoveryQos.setArbitrationStrategy(ArbitrationStrategy.HighestPriority);
        ProxyBuilder proxyBuilder = this.runtime.getProxyBuilder(invocationParameters.getDomainName(), EchoProxy.class);
        return (EchoProxy)proxyBuilder.setMessagingQos(new MessagingQos(3600000L)).setDiscoveryQos(discoveryQos).build();
    }

    private void performSyncSendStringTest(EchoProxy proxy) {
        this.runSyncStringTest(proxy, invocationParameters.getNumberOfWarmupRuns());
        long startTime = System.currentTimeMillis();
        this.runSyncStringTest(proxy, invocationParameters.getNumberOfRuns());
        long endTime = System.currentTimeMillis();
        this.printTestResult(endTime - startTime);
    }

    private void runSyncStringTest(EchoProxy proxy, int runs) {
        String inputString = this.createInputString(invocationParameters.getStringDataLength(), 'x');
        for (int i = 0; i < runs; ++i) {
            proxy.echoString(inputString);
        }
    }

    private void performAsyncSendStringTest(EchoProxy proxy) {
        this.runSyncStringTest(proxy, 1);
        this.runAsyncSendStringTest(proxy, invocationParameters.getNumberOfWarmupRuns());
        long startTime = System.currentTimeMillis();
        int numFailures = this.runAsyncSendStringTest(proxy, invocationParameters.getNumberOfRuns());
        long endTime = System.currentTimeMillis();
        this.printTestResult(endTime - startTime);
        this.printFailureStatistic(numFailures, invocationParameters.getNumberOfRuns());
    }

    private int runAsyncSendStringTest(EchoProxy proxy, int runs) {
        AsyncResponseCounterCallback<String> responseCallback = new AsyncResponseCounterCallback<String>();
        String inputString = this.createInputString(invocationParameters.getStringDataLength(), 'x');
        for (int i = 0; i < runs; ++i) {
            proxy.echoString(responseCallback, inputString);
        }
        responseCallback.waitForNumberOfResponses(runs, 10);
        return responseCallback.getNumberOfFailures();
    }

    private void performSyncSendStructTest(EchoProxy proxy) {
        this.runSyncSendStructTest(proxy, invocationParameters.getNumberOfWarmupRuns());
        long startTime = System.currentTimeMillis();
        this.runSyncSendStructTest(proxy, invocationParameters.getNumberOfRuns());
        long endTime = System.currentTimeMillis();
        this.printTestResult(endTime - startTime);
    }

    private void runSyncSendStructTest(EchoProxy proxy, int runs) {
        ComplexStruct inputData = this.createComplexStructInput();
        for (int i = 0; i < runs; ++i) {
            proxy.echoComplexStruct(inputData);
        }
    }

    private void performAsyncSendStructTest(EchoProxy proxy) {
        this.runSyncSendStructTest(proxy, 1);
        this.runAsyncSendStructTest(proxy, invocationParameters.getNumberOfWarmupRuns());
        long startTime = System.currentTimeMillis();
        int numFailures = this.runAsyncSendStructTest(proxy, invocationParameters.getNumberOfRuns());
        long endTime = System.currentTimeMillis();
        this.printTestResult(endTime - startTime);
        this.printFailureStatistic(numFailures, invocationParameters.getNumberOfRuns());
    }

    private int runAsyncSendStructTest(EchoProxy proxy, int runs) {
        AsyncResponseCounterCallback<ComplexStruct> responseCallback = new AsyncResponseCounterCallback<ComplexStruct>();
        ComplexStruct inputData = this.createComplexStructInput();
        for (int i = 0; i < runs; ++i) {
            proxy.echoComplexStruct(responseCallback, inputData);
        }
        responseCallback.waitForNumberOfResponses(runs, 10);
        return responseCallback.getNumberOfFailures();
    }

    private ComplexStruct createComplexStructInput() {
        ComplexStruct result = new ComplexStruct();
        result.setData(this.createInputByteArray(invocationParameters.getByteArraySize(), (byte)0));
        result.setNum32(1234);
        result.setNum64(42L);
        result.setStr(this.createInputString(invocationParameters.getStringDataLength(), 'x'));
        return result;
    }

    private void performSyncSendByteArrayTest(EchoProxy proxy) {
        this.runSyncSendByteArrayTest(proxy, invocationParameters.getNumberOfWarmupRuns());
        long startTime = System.currentTimeMillis();
        this.runSyncSendByteArrayTest(proxy, invocationParameters.getNumberOfRuns());
        long endTime = System.currentTimeMillis();
        this.printTestResult(endTime - startTime);
    }

    private void runSyncSendByteArrayTest(EchoProxy proxy, int runs) {
        Byte[] inputData = this.createInputByteArray(invocationParameters.getByteArraySize(), (byte)0);
        for (int i = 0; i < runs; ++i) {
            proxy.echoByteArray(inputData);
        }
    }

    private void performAsyncSendByteArrayTest(EchoProxy proxy) {
        this.runSyncSendByteArrayTest(proxy, 1);
        this.runAsyncSendByteArrayTest(proxy, invocationParameters.getNumberOfWarmupRuns());
        long startTime = System.currentTimeMillis();
        int numFailures = this.runAsyncSendByteArrayTest(proxy, invocationParameters.getNumberOfRuns());
        long endTime = System.currentTimeMillis();
        this.printTestResult(endTime - startTime);
        this.printFailureStatistic(numFailures, invocationParameters.getNumberOfRuns());
    }

    private int runAsyncSendByteArrayTest(EchoProxy proxy, int runs) {
        AsyncResponseCounterCallback<Byte[]> responseCallback = new AsyncResponseCounterCallback<Byte[]>();
        Byte[] inputData = this.createInputByteArray(invocationParameters.getByteArraySize(), (byte)0);
        for (int i = 0; i < runs; ++i) {
            proxy.echoByteArray(responseCallback, inputData);
        }
        responseCallback.waitForNumberOfResponses(runs, 10);
        return responseCallback.getNumberOfFailures();
    }

    private Byte[] createInputByteArray(int size, byte value) {
        Object[] result = new Byte[size];
        Arrays.fill(result, new Byte(value));
        return result;
    }

    private String createInputString(int length, char initialChar) {
        char[] data = new char[length];
        Arrays.fill(data, initialChar);
        return new String(data);
    }

    private void printTestResult(long timeDeltaMilliseconds) {
        System.err.format("Test case took %d ms\n", timeDeltaMilliseconds);
    }

    private <type> void printFailureStatistic(int numFailures, int numRuns) {
        if (numFailures > 0) {
            System.err.format("%d out of %d transmissions failed\n", numFailures, numRuns);
        }
    }

    public void shutdown() {
        this.runtime.shutdown(true);
        this.sleep(3000L);
        System.exit(0);
    }

    private boolean sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

