/*
 * Decompiled with CFR 0.152.
 */
package io.jsondb;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.jsondb.DefaultSchemaVersionComparator;
import io.jsondb.crypto.ICipher;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Comparator;

public class JsonDBConfig {
    private Charset charset = Charset.forName("UTF-8");
    private String dbFilesLocationString;
    private File dbFilesLocation;
    private Path dbFilesPath;
    private String baseScanPackage;
    private ICipher cipher;
    private boolean compatibilityMode;
    private ObjectMapper objectMapper;
    private Comparator<String> schemaComparator;

    public JsonDBConfig(String dbFilesLocationString, String baseScanPackage, ICipher cipher, boolean compatibilityMode, Comparator<String> schemaComparator) {
        this.dbFilesLocationString = dbFilesLocationString;
        this.dbFilesLocation = new File(dbFilesLocationString);
        this.dbFilesPath = this.dbFilesLocation.toPath();
        this.baseScanPackage = baseScanPackage;
        this.cipher = cipher;
        this.compatibilityMode = compatibilityMode;
        this.objectMapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        if (compatibilityMode) {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        this.schemaComparator = null == schemaComparator ? new DefaultSchemaVersionComparator() : schemaComparator;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getDbFilesLocationString() {
        return this.dbFilesLocationString;
    }

    public void setDbFilesLocationString(String dbFilesLocationString) {
        this.dbFilesLocationString = dbFilesLocationString;
        this.dbFilesLocation = new File(dbFilesLocationString);
        this.dbFilesPath = this.dbFilesLocation.toPath();
    }

    public File getDbFilesLocation() {
        return this.dbFilesLocation;
    }

    public Path getDbFilesPath() {
        return this.dbFilesPath;
    }

    public String getBaseScanPackage() {
        return this.baseScanPackage;
    }

    public void setBaseScanPackage(String baseScanPackage) {
        this.baseScanPackage = baseScanPackage;
    }

    public ICipher getCipher() {
        return this.cipher;
    }

    public void setCipher(ICipher cipher) {
        this.cipher = cipher;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
        if (compatibilityMode) {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        } else {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Comparator<String> getSchemaComparator() {
        return this.schemaComparator;
    }
}

