/*
 * Decompiled with CFR 0.152.
 */
package io.jsondb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.jsondb.InvalidJsonDbApiUsageException;
import io.jsondb.JsonDBConfig;
import io.jsondb.SchemaVersion;
import io.jsondb.annotation.Document;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static Logger logger = LoggerFactory.getLogger(Util.class);
    private static final Collection<String> RESTRICTED_CLASSES;
    private static ObjectMapper objectMapper;

    protected static void ensureNotRestricted(Object o) {
        if (o.getClass().isArray() || RESTRICTED_CLASSES.contains(o.getClass().getName())) {
            throw new InvalidJsonDbApiUsageException("Collection object cannot be inserted, removed, updated or upserted as a single object");
        }
    }

    protected static <T> String determineEntityCollectionName(T obj) {
        return Util.determineCollectionName(obj.getClass());
    }

    protected static String determineCollectionName(Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidJsonDbApiUsageException("No class parameter provided, entity collection can't be determined");
        }
        Document doc = entityClass.getAnnotation(Document.class);
        if (null == doc) {
            throw new InvalidJsonDbApiUsageException("Entity '" + entityClass.getSimpleName() + "' is not annotated with annotation @Document");
        }
        String collectionName = doc.collection();
        return collectionName;
    }

    protected static Object getIdForEntity(Object document, Method getterMethodForId) {
        Object id = null;
        if (null != getterMethodForId) {
            try {
                id = getterMethodForId.invoke(document, new Object[0]);
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to invoke getter method for a idAnnotated field due to permissions", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("Failed to invoke getter method for a idAnnotated field due to permissions", e);
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to invoke getter method for a idAnnotated field due to wrong arguments", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("Failed to invoke getter method for a idAnnotated field due to wrong arguments", e);
            }
            catch (InvocationTargetException e) {
                logger.error("Failed to invoke getter method for a idAnnotated field, the method threw a exception", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("Failed to invoke getter method for a idAnnotated field, the method threw a exception", e);
            }
        }
        return id;
    }

    protected static Object setIdForEntity(Object document, Method setterMethodForId) {
        Object id = UUID.randomUUID().toString();
        if (null != setterMethodForId) {
            try {
                id = setterMethodForId.invoke(document, id);
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to invoke setter method for a idAnnotated field due to permissions", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("Failed to invoke setter method for a idAnnotated field due to permissions", e);
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to invoke setter method for a idAnnotated field due to wrong arguments", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("Failed to invoke setter method for a idAnnotated field due to wrong arguments", e);
            }
            catch (InvocationTargetException e) {
                logger.error("Failed to invoke setter method for a idAnnotated field, the method threw a exception", (Throwable)e);
                throw new InvalidJsonDbApiUsageException("Failed to invoke setter method for a idAnnotated field, the method threw a exception", e);
            }
        }
        return id;
    }

    protected static Object setFieldValueForEntity(Object document, Object newValue, Method setterMethod) {
        Object retval = null;
        if (null != setterMethod) {
            try {
                retval = setterMethod.invoke(document, newValue);
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to invoke method due to permissions", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to invoke method due to wrong arguments", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("Failed to invoke method, the method threw a exception", (Throwable)e);
            }
        }
        return retval;
    }

    protected static Object deepCopy(Object fromBean) {
        try {
            if (fromBean != null) {
                return objectMapper.readValue(objectMapper.writeValueAsString(fromBean), fromBean.getClass());
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stampVersion(JsonDBConfig dbConfig, File f, String version) {
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(f);
            osr = new OutputStreamWriter((OutputStream)fos, dbConfig.getCharset());
            writer = new BufferedWriter(osr);
            String versionData = dbConfig.getObjectMapper().writeValueAsString((Object)new SchemaVersion(version));
            writer.write(versionData);
            writer.newLine();
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to serialize SchemaVersion to Json string", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error("Failed to write SchemaVersion to the new .json file {}", (Object)f, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error("Failed to close BufferedWriter for new collection file {}", (Object)f, (Object)e);
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                logger.error("Failed to close OutputStreamWriter for new collection file {}", (Object)f, (Object)e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                logger.error("Failed to close FileOutputStream for new collection file {}", (Object)f, (Object)e);
            }
        }
        return true;
    }

    public static void delete(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Util.delete(c);
            }
        }
        f.delete();
    }

    private static int getDefaultIByK(int k, int n) {
        if (k > 0) {
            return 0;
        }
        if (k < 0) {
            return n - 1;
        }
        throw new IllegalArgumentException("Illegal argument, expected k != 0");
    }

    private static int getDefaultJByK(int k, int n) {
        if (k > 0) {
            return n;
        }
        if (k < 0) {
            return -n - 1;
        }
        throw new IllegalArgumentException("Illegal argument, expected k != 0");
    }

    private static int parsePartIJ(String part, int n) throws IllegalArgumentException {
        if ((part = part.trim()).length() > 0) {
            try {
                int p = Integer.parseInt(part);
                if (p < 0) {
                    p += n;
                }
                return p;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal slice argument, expected a integer representing i in i:j:k");
            }
        }
        throw new IllegalArgumentException("Illegal slice argument, expected a integer representing i in i:j:k");
    }

    private static int parsePartK(String part, int def) throws IllegalArgumentException {
        if ((part = part.trim()).length() > 0) {
            try {
                return Integer.parseInt(part);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal slice argument, expected format is i:j:k");
            }
        }
        return def;
    }

    public static boolean isSliceable(String slice) {
        return slice != null && slice.length() >= 1 && !slice.equals(":") && !slice.equals("::");
    }

    public static List<Integer> getSliceIndexes(String slice, int size) {
        ArrayList<Integer> indexes;
        block18: {
            int k;
            int j;
            block17: {
                if (!Util.isSliceable(slice) || size < 1) {
                    return null;
                }
                int i = 0;
                j = 0;
                k = 0;
                String[] parts = slice.split(":");
                if (parts.length > 3) {
                    throw new IllegalArgumentException("Illegal slice argument, expected format is i:j:k");
                }
                if (slice.startsWith("::")) {
                    k = Util.parsePartK(parts[2], 1);
                    i = Util.getDefaultIByK(k, size);
                    j = Util.getDefaultJByK(k, size);
                } else if (slice.startsWith(":")) {
                    if (parts.length == 2) {
                        j = Util.parsePartIJ(parts[1], size);
                        k = 1;
                        i = Util.getDefaultIByK(k, size);
                    } else if (parts.length == 3) {
                        j = Util.parsePartIJ(parts[1], size);
                        k = Util.parsePartK(parts[2], 1);
                        i = Util.getDefaultIByK(k, size);
                    }
                } else if (parts.length == 1) {
                    i = Util.parsePartIJ(parts[0], size);
                    k = 1;
                    j = Util.getDefaultJByK(k, size);
                } else if (parts.length == 2) {
                    i = Util.parsePartIJ(parts[0], size);
                    j = Util.parsePartIJ(parts[1], size);
                    k = 1;
                } else if (parts.length == 3) {
                    k = Util.parsePartK(parts[2], 1);
                    i = parts[0].length() > 0 ? Util.parsePartIJ(parts[0], size) : Util.getDefaultIByK(k, size);
                    j = parts[1].length() > 0 ? Util.parsePartIJ(parts[1], size) : Util.getDefaultJByK(k, size);
                }
                indexes = new ArrayList<Integer>();
                if (k == 0) {
                    throw new IllegalArgumentException("Illegal slice argument, k cannot be zero");
                }
                if (k <= 0) break block17;
                int n = j;
                for (int m = i; m < n && m < size; m += k) {
                    indexes.add(m);
                }
                break block18;
            }
            if (k >= 0) break block18;
            int n = j;
            for (int m = i; m > n && m > -1; m += k) {
                indexes.add(m);
            }
        }
        return indexes;
    }

    static {
        HashSet<String> restrictedClasses = new HashSet<String>();
        restrictedClasses.add(List.class.getName());
        restrictedClasses.add(Collection.class.getName());
        restrictedClasses.add(Iterator.class.getName());
        restrictedClasses.add(HashSet.class.getName());
        RESTRICTED_CLASSES = Collections.unmodifiableCollection(restrictedClasses);
        objectMapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
    }
}

