/*
 * Decompiled with CFR 0.152.
 */
package io.jsondb.crypto;

import io.jsondb.JsonDBException;
import io.jsondb.crypto.ICipher;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Base64;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultAESCBCCipher
implements ICipher {
    private Logger logger = LoggerFactory.getLogger(DefaultAESCBCCipher.class);
    private static final String AES_ENCRYPTION_ALGORITHM = "AES";
    private final String charset;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private ReentrantLock encryptionLock;
    private ReentrantLock decryptionLock;

    public DefaultAESCBCCipher(String base64CodedEncryptionKey) throws GeneralSecurityException {
        this(Base64.getDecoder().decode(base64CodedEncryptionKey), "UTF-8");
    }

    public DefaultAESCBCCipher(String base64CodedEncryptionKey, String charset) throws GeneralSecurityException {
        this(Base64.getDecoder().decode(base64CodedEncryptionKey), charset);
    }

    public DefaultAESCBCCipher(byte[] encryptionKey, String charset) throws GeneralSecurityException {
        this.charset = charset;
        this.encryptionLock = new ReentrantLock();
        this.decryptionLock = new ReentrantLock();
        try {
            this.encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
            this.decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
            SecretKeySpec key = new SecretKeySpec(encryptionKey, AES_ENCRYPTION_ALGORITHM);
            this.encryptCipher.init(1, (Key)key, new IvParameterSpec(encryptionKey));
            this.decryptCipher.init(2, (Key)key, new IvParameterSpec(encryptionKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            this.logger.error("Failed to create DefaultAESCBCCipher", (Throwable)e);
            throw e;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            this.logger.error("Failed to create DefaultAESCBCCipher", (Throwable)e);
            throw new InvalidKeyException("Failed to create DefaultAESCBCCipher, something wrong with the key");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encrypt(String plainText) {
        this.encryptionLock.lock();
        try {
            byte[] cipherBytes = null;
            try {
                cipherBytes = this.encryptCipher.doFinal(plainText.getBytes(this.charset));
            }
            catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
                this.logger.error("DefaultAESCBCCipher failed to encrypt text", (Throwable)e);
                throw new JsonDBException("DefaultAESCBCCipher failed to encrypt text", e);
            }
            String string = Base64.getEncoder().encodeToString(cipherBytes);
            return string;
        }
        finally {
            this.encryptionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(String cipherText) {
        this.decryptionLock.lock();
        try {
            String decryptedValue = null;
            try {
                byte[] bytes = Base64.getDecoder().decode(cipherText);
                decryptedValue = new String(this.decryptCipher.doFinal(bytes), this.charset);
            }
            catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
                this.logger.error("DefaultAESCBCCipher failed to decrypt text", (Throwable)e);
                throw new JsonDBException("DefaultAESCBCCipher failed to decrypt text", e);
            }
            String string = decryptedValue;
            return string;
        }
        finally {
            this.decryptionLock.unlock();
        }
    }
}

