/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.parser;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.parser.AbstractXmlEventParser;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;

public class CloverParser
extends AbstractXmlEventParser {
    private Source source;
    private String packageName;

    public CloverParser(File coverageFile, SourceLoader sourceLoader) {
        super(coverageFile, sourceLoader);
    }

    @Override
    protected void onEvent(XMLStreamReader xml, SourceCallback callback) throws XMLStreamException, ProcessingException, IOException {
        if (this.isStartElement(xml, "package")) {
            this.packageName = xml.getAttributeValue(null, "name");
        } else if (this.isStartElement(xml, "file") && this.packageName != null) {
            String sourceFile = this.getSourceFile(xml.getAttributeValue(null, "name"));
            this.source = this.loadSource(sourceFile);
        } else if (this.isStartElement(xml, "line") && this.source != null) {
            String type = xml.getAttributeValue(null, "type");
            int coverage = 0;
            if ("method".equals(type) || "stmt".equals(type)) {
                coverage = Integer.parseInt(xml.getAttributeValue(null, "count")) == 0 ? 0 : 1;
            } else if ("cond".equals(type)) {
                int falseCount = Integer.parseInt(xml.getAttributeValue(null, "falsecount"));
                int trueCount = Integer.parseInt(xml.getAttributeValue(null, "truecount"));
                coverage = trueCount == 0 || falseCount == 0 ? 0 : 1;
            }
            int lineNumber = Integer.parseInt(xml.getAttributeValue(null, "num"));
            this.source.addCoverage(lineNumber, coverage);
        } else if (this.isEndElement(xml, "file") && this.source != null) {
            callback.onSource(this.source);
            this.source = null;
        } else if (this.isEndElement(xml, "package")) {
            this.packageName = null;
        }
    }

    private String getSourceFile(String fileName) {
        return this.packageName.replace('.', '/') + "/" + fileName;
    }
}

