/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.CompilingTokenProcessor;
import io.jstach.apt.TemplateCompilerLike;
import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.prism.Prisms;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

abstract class AbstractTemplateCompiler
implements TemplateCompilerLike,
TokenProcessor<PositionedToken<MustacheToken>> {
    private Deque<PositionedToken<MustacheToken>> previousTokens = new ArrayDeque<PositionedToken<MustacheToken>>(5);
    protected boolean atStartOfLine = true;
    protected @Nullable PositionedToken<MustacheToken> lastProcessedToken = null;
    protected Position position = Position.noPosition();
    protected String partialIndent = "";

    AbstractTemplateCompiler() {
    }

    @Override
    public final void processToken(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        this.previousTokens.offer(positionedToken);
        this.processTokens();
    }

    protected void debug(CharSequence message) {
        PrintStream out;
        if (this.isDebug() && (out = System.out) != null) {
            out.println("[JSTACHIO] " + this.getTemplateName() + ": " + message);
        }
    }

    protected boolean isDebug() {
        return this.flags().contains((Object)Prisms.Flag.DEBUG);
    }

    private void processTokens() throws ProcessingException {
        boolean eof = this.previousTokens.stream().filter(t -> ((MustacheToken)t.innerToken()).isEOF()).findFirst().isPresent();
        if (eof && !this.previousTokens.getLast().innerToken().isEOF()) {
            throw new IllegalStateException(this.previousTokens.toString());
        }
        ArrayDeque<PositionedToken<MustacheToken>> buf = new ArrayDeque<PositionedToken<MustacheToken>>();
        do {
            buf.clear();
            int size = this.previousTokens.size();
            if (size == 1 && eof) {
                this._processToken(this.previousTokens.poll());
                return;
            }
            if (size < 2 && !eof) {
                return;
            }
            PositionedToken<MustacheToken> firstToken = this.previousTokens.poll();
            PositionedToken<MustacheToken> secondToken = this.previousTokens.poll();
            buf.offerLast(firstToken);
            buf.offerLast(secondToken);
            if (this.atStartOfLine && !firstToken.innerToken().isNewlineToken() && !firstToken.innerToken().isWhitespaceToken() && secondToken.innerToken().isStandaloneToken()) {
                this.processTokenGroup(ProcessToken.of(firstToken), ProcessToken.of(secondToken));
                this.atStartOfLine = false;
                continue;
            }
            if (this.atStartOfLine && firstToken.innerToken().isStandaloneToken() && secondToken.innerToken().isNewlineOrEOF()) {
                this.debug("2 standalone condition: {{#some section}} [ newline ]");
                this.processTokenGroup(ProcessToken.of(firstToken), ProcessToken.ignore(secondToken));
                this.atStartOfLine = true;
                continue;
            }
            if (this.atStartOfLine && size >= 3) {
                PositionedToken<MustacheToken> thirdToken = this.previousTokens.poll();
                buf.add(thirdToken);
                if (firstToken.innerToken().isStandaloneToken() && secondToken.innerToken().isWhitespaceToken() && thirdToken.innerToken().isNewlineOrEOF()) {
                    this.debug("3 standalone condition: {{#some section}} [white space] [ newline ]");
                    this.processTokenGroup(ProcessToken.of(firstToken), ProcessToken.ignore(secondToken), ProcessToken.ignore(thirdToken));
                    this.atStartOfLine = true;
                    continue;
                }
                if (firstToken.innerToken().isWhitespaceToken() && secondToken.innerToken().isStandaloneToken() && thirdToken.innerToken().isNewlineOrEOF()) {
                    this.debug("3 standalone condition: [white space] {{#some section}} [ newline ]");
                    this.processTokenGroup(ProcessToken.indent(firstToken), ProcessToken.of(secondToken), ProcessToken.ignore(thirdToken));
                    this.atStartOfLine = true;
                    continue;
                }
                if (size >= 4) {
                    PositionedToken<MustacheToken> fourthToken = this.previousTokens.poll();
                    buf.add(fourthToken);
                    if (firstToken.innerToken().isWhitespaceToken() && secondToken.innerToken().isStandaloneToken() && thirdToken.innerToken().isWhitespaceToken() && fourthToken.innerToken().isNewlineOrEOF()) {
                        this.debug("4 standalone condition: [white space] {{#some section}} [white space] [ newline ]");
                        this.processTokenGroup(ProcessToken.indent(firstToken), ProcessToken.of(secondToken), ProcessToken.ignore(thirdToken), ProcessToken.ignore(fourthToken));
                        this.atStartOfLine = true;
                        continue;
                    }
                }
            }
            buf.descendingIterator().forEachRemaining(this.previousTokens::offerFirst);
            if (eof && !this.previousTokens.isEmpty()) {
                this.processTokenGroup(ProcessToken.of(this.previousTokens.poll()));
                continue;
            }
            if (this.previousTokens.size() <= 5) continue;
            this.processTokenGroup(ProcessToken.of(this.previousTokens.poll()));
        } while (eof && !this.previousTokens.isEmpty());
    }

    protected void processTokenGroup(ProcessToken ... tokens) throws ProcessingException {
        this.processTokenGroup(List.of(tokens));
    }

    protected void processTokenGroup(List<ProcessToken> tokens) throws ProcessingException {
        Iterator<ProcessToken> it = tokens.iterator();
        while (it.hasNext()) {
            ProcessToken token = it.next();
            switch (token.hint()) {
                case IGNORE: {
                    break;
                }
                case INDENT: {
                    ProcessToken nextToken = it.next();
                    this._processIndentToken(token.token(), nextToken.token());
                    break;
                }
                case NORMAL: 
                case EOF: {
                    this._processToken(token.token());
                }
            }
        }
    }

    protected void _processToken(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        this.position = positionedToken.position();
        positionedToken.innerToken().accept(new CompilingTokenProcessor(this));
        this.atStartOfLine = positionedToken.innerToken().isNewlineOrEOF();
        this.lastProcessedToken = positionedToken;
    }

    protected void _processIndentToken(PositionedToken<MustacheToken> whitespace, PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        if (positionedToken.innerToken().isIndented()) {
            MustacheToken mustacheToken = whitespace.innerToken();
            if (mustacheToken instanceof MustacheToken.TextToken) {
                MustacheToken.TextToken tt = (MustacheToken.TextToken)mustacheToken;
                if (this.isDebug()) {
                    this.debug("Setting indent. whitespace: " + tt + " standalone: " + positionedToken.innerToken());
                }
                this.partialIndent = tt.text();
            } else {
                throw new IllegalStateException("whitespace token is wrong");
            }
        }
        this._processToken(positionedToken);
    }

    protected abstract void _endOfFile() throws ProcessingException;

    protected abstract void _text(String var1) throws ProcessingException;

    protected abstract void _newline(MustacheToken.NewlineChar var1) throws ProcessingException;

    protected abstract void _specialCharacter(MustacheToken.SpecialChar var1) throws ProcessingException;

    protected abstract void _unescapedVariable(String var1) throws ProcessingException;

    protected abstract void _partial(String var1) throws ProcessingException;

    protected abstract void _variable(String var1) throws ProcessingException;

    protected abstract void _endSection(String var1) throws ProcessingException;

    protected abstract void _beginBlockSection(String var1) throws ProcessingException;

    protected abstract void _beginParentSection(String var1) throws ProcessingException;

    protected abstract void _beginInvertedSection(String var1) throws ProcessingException;

    protected abstract void _beginSection(String var1) throws ProcessingException;

    protected record ProcessToken(PositionedToken<MustacheToken> token, ProcessHint hint) {
        protected static ProcessToken ignore(PositionedToken<MustacheToken> token) {
            if (token.innerToken().isEOF()) {
                return new ProcessToken(token, ProcessHint.EOF);
            }
            return new ProcessToken(token, ProcessHint.IGNORE);
        }

        protected static ProcessToken of(PositionedToken<MustacheToken> token) {
            if (token.innerToken().isEOF()) {
                return new ProcessToken(token, ProcessHint.EOF);
            }
            return new ProcessToken(token, ProcessHint.NORMAL);
        }

        protected static ProcessToken indent(PositionedToken<MustacheToken> token) {
            if (token.innerToken().isEOF()) {
                return new ProcessToken(token, ProcessHint.EOF);
            }
            return new ProcessToken(token, ProcessHint.INDENT);
        }

        protected static enum ProcessHint {
            IGNORE,
            INDENT,
            NORMAL,
            EOF;

        }
    }
}

