/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.NamedReader;
import io.jstach.apt.SwitchablePrintWriter;
import io.jstach.apt.TemplateCompiler;
import io.jstach.apt.TemplateCompilerLike;
import io.jstach.apt.TextFileObject;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.ProcessingConfig;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.RenderingCodeGenerator;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.prism.Prisms;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

class CodeWriter {
    private final SwitchablePrintWriter writer;
    private final RenderingCodeGenerator codeGenerator;
    private final Map<String, NamedTemplate> partials;
    private final ProcessingConfig config;

    CodeWriter(SwitchablePrintWriter writer, RenderingCodeGenerator codeGenerator, Map<String, NamedTemplate> partials, ProcessingConfig config) {
        this.writer = writer;
        this.codeGenerator = codeGenerator;
        this.partials = partials;
        this.config = config;
    }

    TemplateCompilerContext createTemplateContext(NamedTemplate template, TypeElement element, String rootExpression, VariableContext variableContext, Set<Prisms.Flag> flags) throws AnnotatedException {
        return this.codeGenerator.createTemplateCompilerContext(TemplateStack.ofRoot(template, flags), element, rootExpression, variableContext);
    }

    void println(String s) {
        this.writer.println(s);
    }

    void compileTemplate(TextFileObject resource, TemplateCompilerContext context, TemplateCompilerLike.TemplateCompilerType templateCompilerType) throws IOException, ProcessingException {
        TemplateStack stack = context.getTemplateStack();
        String templateName = stack.getTemplateName();
        if (!(stack instanceof TemplateStack.RootTemplateStack)) {
            throw new IllegalStateException("Expected root template");
        }
        TemplateStack.RootTemplateStack rt = (TemplateStack.RootTemplateStack)stack;
        NamedTemplate rootTemplate = rt.template();
        TemplateCompilerLike.TemplateLoader templateLoader = name -> {
            NamedTemplate nt = name.equals(templateName) ? rootTemplate : this.partials.get(name);
            if (nt == null) {
                nt = new NamedTemplate.FileTemplate(name, name);
            }
            if (nt instanceof NamedTemplate.FileTemplate) {
                NamedTemplate.FileTemplate ft = (NamedTemplate.FileTemplate)nt;
                String path = ft.path();
                path = this.config.pathConfig().resolveTemplatePath(path);
                return new NamedReader(new InputStreamReader((InputStream)new BufferedInputStream(resource.openInputStream(path)), resource.charset()), name, path);
            }
            if (nt instanceof NamedTemplate.InlineTemplate) {
                NamedTemplate.InlineTemplate it = (NamedTemplate.InlineTemplate)nt;
                String template = it.template();
                StringReader sr = new StringReader(template);
                return new NamedReader(sr, name, "INLINE");
            }
            throw new IllegalStateException();
        };
        try (TemplateCompiler templateCompiler = TemplateCompiler.createCompiler(templateName, templateLoader, this.writer, context, templateCompilerType, this.config.flags());){
            templateCompiler.run();
        }
    }
}

