/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.CodeWriter;
import io.jstach.apt.DeclarationException;
import io.jstach.apt.ServicesFiles;
import io.jstach.apt.SwitchablePrintWriter;
import io.jstach.apt.TemplateClassWriter;
import io.jstach.apt.TextFileObject;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.ProcessingConfig;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.RenderingCodeGenerator;
import io.jstach.apt.internal.meta.ElementMessage;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.internal.util.Throwables;
import io.jstach.apt.prism.JStacheConfigPrism;
import io.jstach.apt.prism.JStacheContentTypePrism;
import io.jstach.apt.prism.JStacheFlagsPrism;
import io.jstach.apt.prism.JStacheFormatterPrism;
import io.jstach.apt.prism.JStacheFormatterTypesPrism;
import io.jstach.apt.prism.JStacheInterfacesPrism;
import io.jstach.apt.prism.JStachePartialPrism;
import io.jstach.apt.prism.JStachePartialsPrism;
import io.jstach.apt.prism.JStachePathPrism;
import io.jstach.apt.prism.JStachePrism;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@SupportedAnnotationTypes(value={"*"})
public class GenerateRendererProcessor
extends AbstractProcessor
implements Prisms {
    Set<ClassRef> rendererClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<ElementMessage> errors = new ArrayList<ElementMessage>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private static String formatErrorMessage(Position position, @Nullable String message) {
        message = message == null ? "" : message;
        String formatString = "%s:%d: error: %s%n%s%n%s%nsymbol: mustache directive%nlocation: mustache template";
        @Nullable Object @NonNull [] fields = new Object[]{position.fileName(), position.row(), message, position.currentLine(), GenerateRendererProcessor.columnPositioningString(position.col())};
        return String.format(formatString, fields);
    }

    private static String columnPositioningString(int col) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < col - 1; ++i) {
            builder.append(' ');
        }
        builder.append('^');
        return builder.toString();
    }

    @Override
    public @NonNull Set<@NonNull String> getSupportedAnnotationTypes() {
        return Set.copyOf(Prisms.ANNOTATIONS);
    }

    @Override
    public boolean process(Set<? extends TypeElement> processEnnotations, RoundEnvironment roundEnv) {
        try {
            return this._process(processEnnotations, roundEnv);
        }
        catch (AnnotatedException e) {
            e.report(this.processingEnv.getMessager());
            return true;
        }
    }

    private boolean _process(Set<? extends TypeElement> processEnnotations, RoundEnvironment roundEnv) throws AnnotatedException {
        JavaLanguageModel.createInstance(this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), this.processingEnv.getMessager());
        if (roundEnv.processingOver()) {
            for (ElementMessage error : this.errors) {
                TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(error.qualifiedElementName());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error.message(), typeElement);
            }
            ClassRef serviceClass = ClassRef.ofBinaryName("io.jstach.jstachio.spi.TemplateProvider");
            ServicesFiles.writeServicesFile(this.processingEnv.getFiler(), this.processingEnv.getMessager(), serviceClass, this.rendererClasses);
            return false;
        }
        TypeElement jstacheElement = this.processingEnv.getElementUtils().getTypeElement("io.jstach.jstache.JStache");
        for (Element element : roundEnv.getElementsAnnotatedWith(jstacheElement)) {
            TypeElement typeElement = (TypeElement)element;
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            AnnotationMirror directive = null;
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!this.processingEnv.getTypeUtils().isSubtype(annotationMirror.getAnnotationType(), jstacheElement.asType())) continue;
                directive = annotationMirror;
            }
            assert (directive != null);
            ClassRef ref = this.writeRenderableAdapterClass(typeElement, directive);
            if (ref == null) continue;
            this.rendererClasses.add(ref);
        }
        TypeElement jstachesElement = this.processingEnv.getElementUtils().getTypeElement("io.jstach.jstache.JStaches");
        for (Element element : roundEnv.getElementsAnnotatedWith(jstachesElement)) {
            TypeElement classElement = (TypeElement)element;
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!this.processingEnv.getTypeUtils().isSubtype(annotationMirror.getAnnotationType(), jstachesElement.asType())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                    List directives = (List)entry.getValue().getValue();
                    for (AnnotationValue directiveValue : directives) {
                        AnnotationMirror directive = (AnnotationMirror)directiveValue.getValue();
                        assert (directive != null);
                        ClassRef ref = this.writeRenderableAdapterClass(classElement, directive);
                        if (ref == null) continue;
                        this.rendererClasses.add(ref);
                    }
                }
            }
        }
        return true;
    }

    private ProcessingConfig.PathConfig resolvePathConfig(TypeElement element) {
        JStachePathPrism prism = this.findPrisms(element, JStachePathPrism::getInstanceOn).stream().findFirst().orElse(null);
        if (prism == null) {
            return new ProcessingConfig.PathConfig("", "");
        }
        return new ProcessingConfig.PathConfig(prism.prefix(), prism.suffix());
    }

    private InterfacesConfig resolveBaseInterfaces(TypeElement element) throws AnnotatedException {
        List<JStacheInterfacesPrism> prisms = this.findPrisms(element, JStacheInterfacesPrism::getInstanceOn);
        List<String> templateInterfaces = prisms.stream().map(JStacheInterfacesPrism::templateImplements).flatMap(faces -> faces.stream()).map(tm -> this.getTypeName((TypeMirror)tm)).toList();
        List<String> templateAnnotions = prisms.stream().map(JStacheInterfacesPrism::templateAnnotations).flatMap(faces -> faces.stream()).map(tm -> this.getTypeName((TypeMirror)tm)).toList();
        List<String> templateConstructorAnnotations = prisms.stream().map(JStacheInterfacesPrism::templateConstructorAnnotations).flatMap(faces -> faces.stream()).map(tm -> this.getTypeName((TypeMirror)tm)).toList();
        List modelInterfaces = prisms.stream().map(JStacheInterfacesPrism::modelImplements).flatMap(faces -> faces.stream()).toList();
        for (TypeMirror mi : modelInterfaces) {
            if (JavaLanguageModel.getInstance().isSubtype(element.asType(), mi)) continue;
            throw new AnnotatedException(element, "per package declaration of @io.jstach.jstache.JStacheInterfaces model required to implement " + mi.toString());
        }
        return new InterfacesConfig(templateInterfaces, templateAnnotions, templateConstructorAnnotations);
    }

    private <T> List<T> findPrisms(TypeElement element, Function<Element, @Nullable T> prismSupplier) {
        ModuleElement moduleElement = this.processingEnv.getElementUtils().getModuleOf(element);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
        return this.findPrisms(Stream.of(element, packageElement, moduleElement), prismSupplier);
    }

    private <T> List<T> findPrisms(Stream<Element> elements, Function<Element, @Nullable T> prismSupplier) {
        return elements.filter(e -> e != null).map(prismSupplier).filter(e -> e != null).toList();
    }

    private Map<String, NamedTemplate> resolvePartials(TypeElement element) {
        LinkedHashMap<String, NamedTemplate> paths = new LinkedHashMap<String, NamedTemplate>();
        List<JStachePartialsPrism> prisms = this.findPrisms(element, JStachePartialsPrism::getInstanceOn);
        for (JStachePartialsPrism prism : prisms) {
            List<JStachePartialPrism> tps = prism.value();
            for (JStachePartialPrism tp : tps) {
                String path = tp.path();
                String name = tp.name();
                assert (name != null);
                String template = tp.template();
                NamedTemplate nt = GenerateRendererProcessor.resolveNamedTemplate(name, path, template);
                paths.putIfAbsent(name, nt);
            }
        }
        return paths;
    }

    private static NamedTemplate resolveNamedTemplate(String name, @Nullable String path, @Nullable String template) {
        assert (name != null);
        Record nt = path != null && !path.isBlank() ? new NamedTemplate.FileTemplate(name, path) : (template != null && !template.isEmpty() ? new NamedTemplate.InlineTemplate(name, template) : new NamedTemplate.FileTemplate(name, name));
        return nt;
    }

    private Set<Prisms.Flag> resolveFlags(TypeElement element) {
        JStacheFlagsPrism prism = this.findPrisms(element, JStacheFlagsPrism::getInstanceOn).stream().findFirst().orElse(null);
        EnumSet<Prisms.Flag> flags = EnumSet.noneOf(Prisms.Flag.class);
        if (prism != null) {
            prism.flags().stream().map(Prisms.Flag::valueOf).forEach(flags::add);
        }
        return Collections.unmodifiableSet(flags);
    }

    private String getTypeName(TypeMirror tm) {
        Element e = ((DeclaredType)tm).asElement();
        TypeElement te = (TypeElement)e;
        return te.getQualifiedName().toString();
    }

    private FormatterTypes resolveFormatterTypes(TypeElement element) {
        List<JStacheFormatterTypesPrism> prisms = this.findPrisms(element, JStacheFormatterTypesPrism::getInstanceOn);
        List<String> classNames = prisms.stream().flatMap(p -> p.types().stream()).map(tm -> this.getTypeName((TypeMirror)tm)).toList();
        List<String> patterns = prisms.stream().flatMap(p -> p.patterns().stream()).toList();
        if (classNames.isEmpty() && patterns.isEmpty()) {
            return FormatterTypes.acceptOnlyKnownTypes();
        }
        return new FormatterTypes.ConfiguredFormatterTypes(classNames, patterns);
    }

    private RendererModel model(TypeElement element, AnnotationMirror directiveMirror) throws DeclarationException, AnnotatedException, DeclarationException {
        if (!element.getTypeParameters().isEmpty()) {
            throw new DeclarationException("Can't generate renderer for class with type variables: " + element.getQualifiedName());
        }
        JStachePrism gp = JStachePrism.getInstance(directiveMirror);
        if (gp == null) {
            throw new AnnotatedException(element, "Missing annotation. bug.");
        }
        FormatterTypes.FormatCallType formatCallType = this.resolveFormatCallType(element);
        Charset charset = this.resolveCharset(element);
        TypeElement contentTypeElement = this.resolveContentType(element, gp);
        TypeElement formatterElement = this.resolveFormatter(element, gp);
        String path = gp.path();
        ProcessingConfig.PathConfig pathConfig = this.resolvePathConfig(element);
        String template = gp.template();
        assert (template != null);
        InterfacesConfig ifaces = this.resolveBaseInterfaces(element);
        ClassRef rendererClassRef = this.resolveRendererClassRef(element, gp);
        FormatterTypes formatterTypes = this.resolveFormatterTypes(element);
        Map<String, NamedTemplate> partials = this.resolvePartials(element);
        Set<Prisms.Flag> flags = this.resolveFlags(element);
        RendererModel model = new RendererModel(formatCallType, element, rendererClassRef, path, pathConfig, template, charset, contentTypeElement, formatterTypes, formatterElement, partials, ifaces, flags);
        return model;
    }

    private FormatterTypes.FormatCallType resolveFormatCallType(TypeElement element) {
        Prisms.JStacheType type = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).stream().map(config -> Prisms.JStacheType.valueOf(config.type())).findFirst().orElse(Prisms.JStacheType.AUTO);
        FormatterTypes.FormatCallType formatCallType = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Prisms.JStacheType.AUTO -> FormatterTypes.FormatCallType.JSTACHIO;
            case Prisms.JStacheType.STACHE -> FormatterTypes.FormatCallType.STACHE;
            case Prisms.JStacheType.JSTACHIO -> FormatterTypes.FormatCallType.JSTACHIO;
        };
        return formatCallType;
    }

    private Charset resolveCharset(TypeElement element) {
        @Nullable String cs = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).stream().map(config -> config.charset()).filter(c -> !c.isBlank()).findFirst().orElse(null);
        cs = cs == null ? "" : cs;
        Charset charset = cs.isBlank() ? StandardCharsets.UTF_8 : Charset.forName(cs);
        return charset;
    }

    private ClassRef resolveRendererClassRef(TypeElement element, JStachePrism gp) {
        String rendererClassSimpleName = this.resolveAdapterName(element, gp);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
        assert (packageElement != null);
        ClassRef rendererClassRef = ClassRef.of(packageElement, rendererClassSimpleName);
        return rendererClassRef;
    }

    private TypeElement resolveContentType(TypeElement element, JStachePrism gp) throws DeclarationException {
        JavaLanguageModel lm = JavaLanguageModel.getInstance();
        TypeElement autoContentTypeElement = lm.getElements().getTypeElement("io.jstach.jstache.JStacheContentType.AutoContentType");
        Stream<TypeMirror> contentTypeProviderTypes = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).stream().map(p -> p.contentType());
        Throwables.SneakyFunction f = this::contentTypeElement;
        @Nullable TypeElement contentTypeProviderElement = Stream.concat(Stream.of(gp.contentType()), contentTypeProviderTypes).map(f).filter(e -> !lm.isSameType(autoContentTypeElement.asType(), e.asType())).findFirst().orElse(null);
        if (contentTypeProviderElement == null) {
            contentTypeProviderElement = lm.getElements().getTypeElement("io.jstach.jstachio.escapers.Html");
        }
        return contentTypeProviderElement;
    }

    private TypeElement resolveFormatter(TypeElement element, JStachePrism gp) throws DeclarationException {
        JavaLanguageModel lm = JavaLanguageModel.getInstance();
        TypeElement autoFormatElement = lm.getElements().getTypeElement("io.jstach.jstache.JStacheFormatter.AutoFormatter");
        Stream<TypeMirror> formatterProviderTypes = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).stream().map(p -> p.formatter());
        Throwables.SneakyFunction f = this::formatterElement;
        @Nullable TypeElement formatterProviderElement = Stream.concat(Stream.of(gp.formatter()), formatterProviderTypes).map(f).filter(e -> !lm.isSameType(autoFormatElement.asType(), e.asType())).findFirst().orElse(null);
        if (formatterProviderElement == null) {
            formatterProviderElement = lm.getElements().getTypeElement("io.jstach.jstachio.formatters.DefaultFormatter");
        }
        return formatterProviderElement;
    }

    private TypeElement formatterElement(TypeMirror templateFormatType) throws DeclarationException {
        TypeElement formatElement = null;
        if (!(templateFormatType instanceof DeclaredType)) {
            throw new ClassCastException("Expecting DeclaredType for formatter " + templateFormatType);
        }
        DeclaredType dt = (DeclaredType)templateFormatType;
        formatElement = (TypeElement)dt.asElement();
        JStacheFormatterPrism formatterPrism = JStacheFormatterPrism.getInstanceOn(formatElement);
        if (formatterPrism == null) {
            throw new DeclarationException(formatElement.getQualifiedName() + " class is used as a formatter, but not marked with io.jstach.jstache.JStacheFormatter annotation");
        }
        return formatElement;
    }

    private TypeElement contentTypeElement(TypeMirror templateContentType) throws DeclarationException {
        TypeElement contentTypeElement = null;
        if (!(templateContentType instanceof DeclaredType)) {
            throw new ClassCastException("Expecting DeclaredType for content type " + templateContentType);
        }
        DeclaredType dt = (DeclaredType)templateContentType;
        contentTypeElement = (TypeElement)dt.asElement();
        JStacheContentTypePrism formatterPrism = JStacheContentTypePrism.getInstanceOn(contentTypeElement);
        if (formatterPrism == null) {
            throw new DeclarationException(contentTypeElement.getQualifiedName() + " class is used as a contentType, but not marked with io.jstach.jstache.JStacheContentType annotation");
        }
        return contentTypeElement;
    }

    private String resolveAdapterName(TypeElement element, JStachePrism gp) {
        Object adapterClassSimpleName;
        String directiveAdapterName = gp.adapterName();
        if (directiveAdapterName.isBlank()) {
            @Nullable String suffix = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).stream().map(config -> config.nameSuffix()).filter(n -> !n.isBlank()).findFirst().orElse(null);
            suffix = suffix != null ? suffix : "Renderer";
            ClassRef ref = ClassRef.of(element);
            adapterClassSimpleName = ref.getSimpleName() + suffix;
        } else {
            adapterClassSimpleName = directiveAdapterName;
        }
        return adapterClassSimpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable ClassRef writeRenderableAdapterClass(TypeElement element, AnnotationMirror directiveMirror) throws AnnotatedException {
        try {
            RendererModel model;
            RendererModel config = model = this.model(element, directiveMirror);
            StringWriter stringWriter = new StringWriter();
            try (SwitchablePrintWriter switchablePrintWriter = SwitchablePrintWriter.createInstance(stringWriter);){
                TextFileObject templateResource = new TextFileObject(config, Objects.requireNonNull(this.processingEnv));
                JavaLanguageModel javaModel = JavaLanguageModel.getInstance();
                RenderingCodeGenerator codeGenerator = RenderingCodeGenerator.createInstance(javaModel, model.formatterTypes(), model.formatCallType());
                CodeWriter codeWriter = new CodeWriter(switchablePrintWriter, codeGenerator, model.partials(), config);
                TemplateClassWriter writer = new TemplateClassWriter(codeWriter, templateResource, model.formatCallType());
                writer.writeRenderableAdapterClass(model);
            }
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(model.rendererClassRef().requireCanonicalName(), element);
            OutputStream stream = sourceFile.openOutputStream();
            try (OutputStreamWriter outputWriter = new OutputStreamWriter(stream, Charset.defaultCharset());){
                ((Writer)outputWriter).append(stringWriter.getBuffer().toString());
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, Throwables.render(ex), element);
                }
            }
            return model.rendererClassRef();
        }
        catch (ProcessingException ex) {
            String errorMessage = GenerateRendererProcessor.formatErrorMessage(ex.position(), ex.getMessage());
            this.errors.add(ElementMessage.of(element, errorMessage));
        }
        catch (DeclarationException ex) {
            this.errors.add(ElementMessage.of(element, ex.toString()));
        }
        catch (IOException ex) {
            this.errors.add(ElementMessage.of(element, Throwables.render(ex)));
        }
        catch (RuntimeException ex) {
            this.errors.add(ElementMessage.of(element, Throwables.render(ex)));
        }
        return null;
    }

    record InterfacesConfig(List<String> templateInterfaces, List<String> templateAnnotations, List<String> templateConstructorAnnotations) {
    }

    record RendererModel(FormatterTypes.FormatCallType formatCallType, TypeElement element, ClassRef rendererClassRef, String path, ProcessingConfig.PathConfig pathConfig, String template, Charset charset, TypeElement contentTypeElement, FormatterTypes formatterTypes, TypeElement formatterTypeElement, Map<String, NamedTemplate> partials, InterfacesConfig ifaces, Set<Prisms.Flag> flags) implements ProcessingConfig
    {
        public NamedTemplate namedTemplate() {
            Object name;
            Object path = this.path();
            String template = null;
            if (!((String)path).isBlank()) {
                name = path;
            } else if (!this.template().isEmpty()) {
                name = this.element.getQualifiedName().toString() + "#template";
                template = this.template();
            } else {
                PackageElement pe = JavaLanguageModel.getInstance().getElements().getPackageOf(this.element);
                String folder = pe.getQualifiedName().toString().replace('.', '/');
                name = path = folder.isEmpty() ? this.element.getQualifiedName().toString() : folder + "/" + this.element.getSimpleName();
            }
            return GenerateRendererProcessor.resolveNamedTemplate((String)name, (String)path, template);
        }
    }
}

