/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import java.io.IOException;
import java.io.Writer;

class SwitchableWriter
extends Writer {
    private final Writer writer;
    private boolean suppressesOutput = false;

    public SwitchableWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.suppressesOutput) {
            this.writer.write(cbuf, off, len);
        }
    }

    public boolean suppressesOutput() {
        return this.suppressesOutput;
    }

    public void enableOutput() {
        this.suppressesOutput = false;
    }

    public void disableOutput() {
        this.suppressesOutput = true;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

