/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.CodeWriter;
import io.jstach.apt.GenerateRendererProcessor;
import io.jstach.apt.TemplateCompilerLike;
import io.jstach.apt.TextFileObject;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.prism.JStacheContentTypePrism;
import io.jstach.apt.prism.JStacheFormatterPrism;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

class TemplateClassWriter {
    private final CodeWriter codeWriter;
    private final TextFileObject templateLoader;
    private final FormatterTypes.FormatCallType formatCallType;
    final String idt = "\n        ";
    final String _F_Formatter = Function.class.getName() + "< /* @Nullable */ Object, String>";
    final String _F_Escaper = Function.class.getName() + "<String, String>";
    final String _Appendable = Appendable.class.getName();

    TemplateClassWriter(CodeWriter compilerManager, TextFileObject templateLoader, FormatterTypes.FormatCallType formatCallType) {
        this.codeWriter = compilerManager;
        this.templateLoader = templateLoader;
        this.formatCallType = formatCallType;
    }

    void println(String s) {
        this.codeWriter.println(s);
    }

    void writeRenderableAdapterClass(GenerateRendererProcessor.RendererModel model) throws IOException, ProcessingException, AnnotatedException {
        boolean jstachio = this.formatCallType == FormatterTypes.FormatCallType.JSTACHIO;
        TypeElement element = model.element();
        TypeElement contentTypeElement = model.contentTypeElement();
        TypeElement formatterTypeElement = model.formatterTypeElement();
        GenerateRendererProcessor.InterfacesConfig ifaces = model.ifaces();
        ClassRef renderClassRef = model.rendererClassRef();
        ClassRef modelClassRef = ClassRef.of(element);
        String className = modelClassRef.getCanonicalName();
        if (className == null) {
            throw new AnnotatedException(element, "Anonymous classes can not be used as models");
        }
        String packageName = modelClassRef.getPackageName();
        JStacheContentTypePrism contentTypePrism = JStacheContentTypePrism.getInstanceOn(contentTypeElement);
        assert (contentTypePrism != null);
        JStacheFormatterPrism formatterPrism = JStacheFormatterPrism.getInstanceOn(formatterTypeElement);
        assert (formatterPrism != null);
        ArrayList<Object> interfaces = new ArrayList<Object>();
        if (jstachio) {
            interfaces.add("io.jstach.jstachio.Template<" + className + ">");
            interfaces.add("io.jstach.jstachio.TemplateInfo");
            interfaces.add("io.jstach.jstachio.spi.TemplateProvider");
            interfaces.add("io.jstach.jstachio.spi.JStachioFilter.FilterChain");
        }
        interfaces.addAll(ifaces.templateInterfaces());
        String implementsString = interfaces.stream().collect(Collectors.joining(",\n    "));
        String rendererAnnotated = ifaces.templateAnnotations().stream().map(ta -> "@" + ta + "\n").collect(Collectors.joining());
        String constructorAnnotated = ifaces.templateConstructorAnnotations().stream().map(ta -> "@" + ta + "\n").collect(Collectors.joining());
        Object rendererImplements = implementsString.isBlank() ? "" : " implements " + implementsString;
        String modifier = element.getModifiers().contains((Object)Modifier.PUBLIC) ? "public " : "";
        String rendererClassSimpleName = renderClassRef.getSimpleName();
        NamedTemplate namedTemplate = model.namedTemplate();
        String templateName = namedTemplate.name();
        String templatePath = model.pathConfig().resolveTemplatePath(model.namedTemplate().path());
        String templateString = namedTemplate.template();
        String templateStringJava = CodeAppendable.stringConcat(templateString);
        String _Appender = "io.jstach.jstachio.Appender<" + this._Appendable + ">";
        String _Formatter = jstachio ? "io.jstach.jstachio.Formatter" : this._F_Formatter;
        String _Escaper = jstachio ? "io.jstach.jstachio.Escaper" : this._F_Escaper;
        String contentTypeProvideCall = contentTypeElement.getQualifiedName() + "." + contentTypePrism.providesMethod() + "()";
        String formatterProvideCall = formatterTypeElement.getQualifiedName() + "." + formatterPrism.providesMethod() + "()";
        this.println("package " + packageName + ";");
        this.println("");
        this.println("/**");
        this.println(" * Generated Renderer.");
        this.println(" */");
        this.println("// @javax.annotation.Generated(\"" + GenerateRendererProcessor.class.getName() + "\")");
        if (!rendererAnnotated.isBlank()) {
            this.println(rendererAnnotated);
        }
        this.println(modifier + "class " + rendererClassSimpleName + (String)rendererImplements + " {");
        this.println("    /**");
        this.println("     * Template path.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final String TEMPLATE_PATH = \"" + templatePath + "\";");
        this.println("");
        this.println("    /**");
        this.println("     * Inline template string copied.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("");
        this.println("    public static final String TEMPLATE_STRING = " + templateStringJava + ";");
        this.println("");
        this.println("    /**");
        this.println("     * Template name. Do not rely on this.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final String TEMPLATE_NAME = \"" + templateName + "\";");
        this.println("");
        this.println("    /**");
        this.println("     * The models class. Use {@link #modelClass()} instead.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final Class<?> MODEL_CLASS = " + className + ".class;");
        this.println("");
        this.println("    /**");
        this.println("     * The instance. Use {@link {@link #of()} instead.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    private static final " + rendererClassSimpleName + " INSTANCE = new " + rendererClassSimpleName + "();");
        this.println("");
        this.println("    /**");
        this.println("     * Formatter. ");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    private final " + _Formatter + " formatter;");
        this.println("");
        this.println("    /**");
        this.println("     * Escaper. ");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    private final " + _Escaper + " escaper;");
        this.println("");
        this.println("    /**");
        this.println("     * Renderer constructor for manual wiring.");
        this.println("     * @param formatter formatter if null the static formatter will be used.");
        this.println("     * @param escaper escaper if null the static escaper will be used");
        this.println("     */");
        this.println("    public " + rendererClassSimpleName + "(");
        this.println("        /* @Nullable */ " + this._F_Formatter + " formatter,");
        this.println("        /* @Nullable */ " + this._F_Escaper + " escaper) {");
        this.println("        this.formatter = " + (String)(!jstachio ? "formatter != null ? formatter : (i -> \"\" + i);" : _Formatter + ".of(formatter != null ? formatter : " + formatterProvideCall + ");"));
        this.println("        this.escaper = " + (String)(!jstachio ? "escaper != null ? escaper : (i -> i);" : _Escaper + ".of(escaper != null ? escaper : " + contentTypeProvideCall + ");"));
        this.println("    }");
        this.println("");
        this.println("    /**");
        this.println("     * Renderer constructor for reflection (use of() instead).");
        this.println("     * For programmatic consider using {@link #of()} for a shared singleton.");
        this.println("     */");
        this.println("    public " + rendererClassSimpleName + "() {");
        this.println("        this(null, null);");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Renders the passed in model.");
            this.println("     * @param model a model assumed never to be <code>null</code>.");
            this.println("     * @param appendable the appendable to write to.");
            this.println("     * @throws IOException if there is an error writing to the appendable");
            this.println("     */");
        }
        this.println("    public void execute(" + className + " model, Appendable a) throws java.io.IOException {");
        this.println("        execute(model, a, templateFormatter(), templateEscaper());");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Renders the passed in model.");
            this.println("     * @param model a model assumed never to be <code>null</code>.");
            this.println("     * @param a appendable to write to.");
            this.println("     * @param formatter formats variables before they are passed to the escaper");
            this.println("     * @param escaper used to write escaped variables");
            this.println("     * @throws IOException if an error occurs while writing to the appendable");
            this.println("     */");
        }
        this.println("    public void execute(\n        " + className + " model, \n        " + this._Appendable + " a, \n        " + _Formatter + " formatter,\n        " + _Escaper + " escaper) throws java.io.IOException {");
        if (jstachio) {
            this.println("        render(model, a, formatter, escaper, templateAppender());");
        } else {
            this.println("        render(model, a, formatter, escaper);");
        }
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * If this template support the model class");
            this.println("     * @param type model class.");
            this.println("     * @return true if the renderer supports the class");
            this.println("     */");
        }
        this.println("    public boolean supportsType(Class<?> type) {");
        this.println("        return MODEL_CLASS.isAssignableFrom(type);");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    /**");
            this.println("     * Needed for jstachio runtime.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    @Override");
            this.println("    public java.util.List<io.jstach.jstachio.Template<?>> provideTemplates(io.jstach.jstachio.TemplateConfig templateConfig ) {");
            this.println("        return java.util.List.of(io.jstach.jstachio.TemplateConfig.empty() == templateConfig ? INSTANCE :  new " + rendererClassSimpleName + "(templateConfig));");
            this.println("    }");
            this.println("");
        }
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Template path.");
            this.println("     * @return template path of resource or pseudo inline path");
            this.println("     */");
        }
        this.println("    public String templatePath() {");
        this.println("        return TEMPLATE_PATH;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Logical template name.");
            this.println("     * @return template name");
            this.println("     */");
        }
        this.println("    public String templateName() {");
        this.println("        return TEMPLATE_NAME;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Template contents or blank if path.");
            this.println("     * @return inline template");
            this.println("     */");
        }
        this.println("    public String templateString() {");
        this.println("        return TEMPLATE_STRING;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
            this.println("    public Class<?> templateContentType() {");
            this.println("        return " + contentTypeElement.getQualifiedName() + ".class;");
            this.println("    }");
        }
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Current escaper.");
            this.println("     * @return escaper");
            this.println("     */");
        }
        this.println("    public  " + _Escaper + " templateEscaper() {");
        this.println("        return this.escaper;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Current formatter.");
            this.println("     * @return formatter");
            this.println("     */");
        }
        this.println("    public " + _Formatter + " templateFormatter() {");
        this.println("        return this.formatter;");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    /**");
            this.println("     * Appender.");
            this.println("     * @return appender for writing unescaped variables.");
            this.println("     */");
            this.println("    public " + _Appender + " templateAppender() {");
            this.println("        return io.jstach.jstachio.Appender.defaultAppender();");
            this.println("    }");
            this.println("");
        }
        this.println("    /**");
        this.println("     * Model class.");
        this.println("     * @return class used as model (annotated with JStache).");
        this.println("     */");
        if (jstachio) {
            this.println("    @Override");
        }
        this.println("    public Class<?> modelClass() {");
        this.println("        return MODEL_CLASS;");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    /**");
            this.println("     * Needed for jstachio runtime.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    @SuppressWarnings(\"unchecked\")");
            this.println("    @Override");
            this.println("    public void process(Object model, Appendable appendable) throws java.io.IOException {");
            this.println("        execute( (" + className + ") model, appendable);");
            this.println("    }");
            this.println("");
            this.println("    /**");
            this.println("     * Needed for jstachio runtime.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    @Override");
            this.println("    public boolean isBroken(Object model) {");
            this.println("        return !supportsType(model.getClass());");
            this.println("    }");
            this.println("");
            this.println("    /**");
            this.println("     * Renderer constructor using config.");
            this.println("     * @param templateConfig config that has collaborators");
            this.println("     */");
            if (!constructorAnnotated.isBlank()) {
                this.println(constructorAnnotated);
            }
            this.println("    public " + rendererClassSimpleName + "(io.jstach.jstachio.TemplateConfig templateConfig) {");
            this.println("        this(templateConfig.formatter(), templateConfig.escaper());");
            this.println("    }");
            this.println("");
        }
        this.println("    /**");
        this.println("     * Convience static factory that will reuse the same singleton instance.");
        this.println("     * @return renderer same as calling no-arg constructor but is cached with singleton instance");
        this.println("     */");
        this.println("    public static " + rendererClassSimpleName + " of() {");
        this.println("        return INSTANCE;");
        this.println("    }");
        this.println("");
        this.writeRendererDefinitionMethod(TemplateCompilerLike.TemplateCompilerType.SIMPLE, model);
        this.println("}");
    }

    private void writeRendererDefinitionMethod(TemplateCompilerLike.TemplateCompilerType templateCompilerType, GenerateRendererProcessor.RendererModel model) throws IOException, ProcessingException, AnnotatedException {
        boolean jstachio = this.formatCallType == FormatterTypes.FormatCallType.JSTACHIO;
        TypeElement element = model.element();
        VariableContext variables = VariableContext.createDefaultContext();
        String dataName = variables.introduceNewNameLike("data");
        String className = element.getQualifiedName().toString();
        String _Appender = "io.jstach.jstachio.Appender";
        Object _Escaper = jstachio ? _Appender + "<? super A>" : this._F_Escaper;
        String _Formatter = jstachio ? "io.jstach.jstachio.Formatter" : this._F_Formatter;
        String _A = "<A extends " + this._Appendable + ">";
        this.println("    /**");
        this.println("     * Renders the passed in model.");
        if (jstachio) {
            this.println("     * @param <A> appendable type.");
        }
        this.println("     * @param " + dataName + " model");
        this.println("     * @param " + variables.unescapedWriter() + " appendable to write to.");
        this.println("     * @param " + variables.formatter() + " formats variables before they are passed to the escaper.");
        this.println("     * @param " + variables.escaper() + " used to write escaped variables.");
        if (jstachio) {
            this.println("     * @param " + variables.appender() + " used to write unescaped variables.");
        }
        this.println("     * @throws java.io.IOException if an error occurs while writing to the appendable");
        this.println("     */");
        if (jstachio) {
            this.println("    public static " + _A + " void render(\n        " + className + " " + dataName + ", \n        A " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + (String)_Escaper + " " + variables.escaper() + ",\n        " + _Appender + "<A> " + variables.appender() + ") throws java.io.IOException {");
        } else {
            this.println("    public static  void render(\n        " + className + " " + dataName + ", \n        " + this._Appendable + " " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + (String)_Escaper + " " + variables.escaper() + ") throws java.io.IOException {");
        }
        TemplateCompilerContext context = this.codeWriter.createTemplateContext(model.namedTemplate(), element, dataName, variables, model.flags());
        this.codeWriter.compileTemplate(this.templateLoader, context, templateCompilerType);
        this.println("");
        this.println("    }");
    }
}

