/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.AbstractTemplateCompiler;
import io.jstach.apt.NamedReader;
import io.jstach.apt.SwitchablePrintWriter;
import io.jstach.apt.TemplateCompilerLike;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.token.MustacheTagKind;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

class TemplateCompiler
extends AbstractTemplateCompiler {
    private final NamedReader reader;
    private TemplateCompilerContext context;
    int depth = 0;
    StringBuilder currentUnescaped = new StringBuilder();
    StringBuilder rawLambdaContent = new StringBuilder();
    String indent = "";
    private final @Nullable TemplateCompilerLike parent;
    private @Nullable TemplateCompilerLike.ParameterPartial _partial;
    protected @Nullable CodeAppendable.StringCodeAppendable _currentBlockOutput;
    protected @Nullable CodeAppendable.HiddenCodeAppendable _parentBlockOutput;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemplateCompiler createCompiler(String templateName, TemplateCompilerLike.TemplateLoader templateLoader, CodeAppendable writer, TemplateCompilerContext context, TemplateCompilerLike.TemplateCompilerType compilerType, Set<Prisms.Flag> flags) throws IOException {
        switch (compilerType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SIMPLE: {
                return new SimpleTemplateCompiler(templateName, templateLoader, writer, context, flags);
            }
            case PARTIAL_TEMPLATE: 
            case PARAM_PARTIAL_TEMPLATE: 
            case LAMBDA: {
                throw new IllegalArgumentException("Cannot create partial template as root");
            }
        }
    }

    private TemplateCompiler(NamedReader reader, @Nullable TemplateCompilerLike parent, TemplateCompilerContext context) {
        this.reader = reader;
        this.parent = parent;
        this.context = context;
    }

    @Override
    public void run() throws ProcessingException, IOException {
        int readResult;
        TokenProcessor<@Nullable Character> processor = MustacheTokenizer.createInstance(this.reader.name(), this);
        while ((readResult = this.reader.read()) >= 0) {
            try {
                processor.processToken(Character.valueOf((char)readResult));
            }
            catch (ProcessingException e) {
                if (this.isDebug()) {
                    this.debug(e.getMessage());
                    this.debug(this.context.printStack());
                    e.printStackTrace();
                }
                throw e;
            }
        }
        processor.processToken(TokenProcessor.EOF);
        this.currentWriter().println();
    }

    @Override
    protected void processTokenGroup(List<AbstractTemplateCompiler.ProcessToken> tokens) throws ProcessingException {
        if (this.inLambda()) {
            this.processInsideLambdaToken(tokens);
        } else {
            super.processTokenGroup(tokens);
        }
    }

    void processInsideLambdaToken(List<AbstractTemplateCompiler.ProcessToken> tokens) throws ProcessingException {
        String lambdaName = this.context.currentEnclosedContextName();
        for (AbstractTemplateCompiler.ProcessToken t : tokens) {
            MustacheToken.TagToken tt;
            MustacheToken mt = t.token().innerToken();
            if (mt instanceof MustacheToken.TagToken && (tt = (MustacheToken.TagToken)mt).tagKind() == MustacheTagKind.END_SECTION && lambdaName.equals(tt.name())) {
                super._processToken(t.token());
                continue;
            }
            if (mt.isEOF()) {
                throw new ProcessingException(this.position, "EOF reached before lambda closing tag found. lambda = " + lambdaName);
            }
            mt.appendEscapedJava(this.currentUnescaped);
            mt.appendRawText(this.rawLambdaContent);
        }
    }

    protected boolean inLambda() {
        return this.context.getType() == TemplateCompilerContext.ContextType.LAMBDA;
    }

    @Override
    public @Nullable TemplateCompilerLike getCaller() {
        return this.parent;
    }

    @Override
    public @Nullable TemplateCompilerLike.ParameterPartial currentParameterPartial() {
        return this._partial;
    }

    void popPartial() {
        this._partial = null;
    }

    void pushPartial(TemplateCompilerLike.ParameterPartial partial) {
        this._partial = partial;
    }

    @Override
    public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
        return TemplateCompilerLike.TemplateCompilerType.SIMPLE;
    }

    @Override
    public String getTemplateName() {
        return this.reader.name();
    }

    public CodeAppendable currentWriter() {
        CodeAppendable out = this._currentBlockOutput;
        if (out != null) {
            return out;
        }
        out = this._parentBlockOutput;
        if (out != null) {
            return out;
        }
        return this.getWriter();
    }

    @Override
    public TemplateCompilerLike.ParameterPartial createParameterPartial(String templateName) throws IOException {
        NamedReader reader = this.getTemplateLoader().open(templateName);
        TemplateCompilerContext context = this.context.createForParameterPartial(templateName);
        var c = new TemplateCompiler(reader, this, context){

            @Override
            public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
                return TemplateCompilerLike.TemplateCompilerType.PARAM_PARTIAL_TEMPLATE;
            }
        };
        c.indent = this.partialIndent;
        this.partialIndent = "";
        return new TemplateCompilerLike.ParameterPartial(c);
    }

    public TemplateCompilerLike.Partial createPartial(String templateName) throws IOException {
        NamedReader reader = this.getTemplateLoader().open(templateName);
        TemplateCompilerContext context = this.context.createForPartial(templateName);
        var c = new TemplateCompiler(reader, this, context){

            @Override
            public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
                return TemplateCompilerLike.TemplateCompilerType.PARTIAL_TEMPLATE;
            }
        };
        c.indent = this.partialIndent;
        this.partialIndent = "";
        return new TemplateCompilerLike.Partial(c);
    }

    void flushUnescaped() {
        String code = this.currentUnescaped.toString();
        if (!code.isEmpty()) {
            this._printCodeToWrite(code);
        }
        this.currentUnescaped.setLength(0);
    }

    private void printCodeToWrite(String s) {
        this.currentUnescaped.append(s);
    }

    private void _printCodeToWrite(String s) {
        if (s.isEmpty()) {
            return;
        }
        String code = CodeAppendable.stringLiteralConcat(s);
        this.println();
        this.print(this.context.unescapedWriterExpression() + ".append(" + code + "); ");
        this.println();
    }

    private void print(String s) {
        int i = 0;
        for (String line : s.split("\n")) {
            if (i > 0) {
                this.println();
            }
            this.printIndent();
            this.currentWriter().print(line);
            ++i;
        }
    }

    private void printIndent() {
        for (int i = 0; i <= this.depth + 1; ++i) {
            this.currentWriter().print("    ");
        }
    }

    private void println() {
        this.currentWriter().println();
    }

    private void printBeginSectionComment() {
        this.println();
        this.print("// start " + this.context.getType() + ". name: " + this.context.currentEnclosedContextName() + ", template: " + this.getTemplateName());
        this.println();
    }

    private void printEndSectionComment() {
        this.println();
        this.print("// end " + this.context.getType() + ". name: " + this.context.currentEnclosedContextName() + ", template: " + this.getTemplateName());
        this.println();
    }

    @Override
    protected void _beginSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.SECTION;
        try {
            this.context = this.context.getChild(name, contextType);
            this.printBeginSectionComment();
            this.print(this.context.beginSectionRenderingCode());
            this.println();
            ++this.depth;
            if (this.context.getType() == TemplateCompilerContext.ContextType.LAMBDA) {
                this._beginLambdaSection(name);
            }
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    protected void _beginLambdaSection(String name) {
        if (this.isDebug()) {
            this.debug("Begin lambda. name = " + name);
        }
        this.rawLambdaContent.setLength(0);
    }

    protected void _endLambdaSection(final String name) throws ProcessingException {
        if (this.isDebug()) {
            this.debug("End Lambda. name = " + name);
        }
        try {
            String javaCode = CodeAppendable.stringLiteralConcat(this.currentUnescaped.toString());
            this.currentUnescaped.setLength(0);
            String rawBody = this.rawLambdaContent.toString();
            this.rawLambdaContent.setLength(0);
            final TemplateCompiler self = this;
            TemplateCompilerContext.LambdaCompiler lambdaCompiler = new TemplateCompilerContext.LambdaCompiler(){

                @Override
                public String run(TemplateCompilerContext rootContext, Reader reader) throws IOException, ProcessingException {
                    NamedReader namedReader = new NamedReader(reader, name, "INLINE");
                    final CodeAppendable.StringCodeAppendable codeAppendable = new CodeAppendable.StringCodeAppendable();
                    try (TemplateCompiler c = new TemplateCompiler(namedReader, self, rootContext){

                        @Override
                        public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
                            return TemplateCompilerLike.TemplateCompilerType.LAMBDA;
                        }

                        @Override
                        public CodeAppendable getWriter() {
                            return codeAppendable;
                        }
                    };){
                        c.run();
                        String string = codeAppendable.toString();
                        return string;
                    }
                }
            };
            this.print(this.context.lambdaRenderingCode(rawBody, javaCode, lambdaCompiler));
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
        catch (IOException ioe) {
            throw new ProcessingException(this.position, ioe);
        }
        catch (AnnotatedException ae) {
            throw new ProcessingException.AnnotationProcessingException(this.position, ae);
        }
    }

    @Override
    protected void _beginInvertedSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.INVERTED;
        try {
            this.context = this.context.getChild(name, contextType);
            this.printBeginSectionComment();
            this.print(this.context.beginSectionRenderingCode());
            this.println();
            ++this.depth;
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    @Override
    protected void _beginParentSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.PARENT_PARTIAL;
        try {
            this.context = this.context.getChild(name, contextType);
            this.printBeginSectionComment();
            TemplateCompilerLike.ParameterPartial p = this.currentParameterPartial();
            if (p != null) {
                throw new IllegalStateException("parent (parameter partial) is already started for this context");
            }
            p = this.createParameterPartial(name);
            this.pushPartial(p);
            this._parentBlockOutput = new CodeAppendable.HiddenCodeAppendable(s -> {});
        }
        catch (ContextException | IOException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    @Override
    protected void _beginBlockSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.BLOCK;
        try {
            this.context = this.context.getChild(name, contextType);
            this.printBeginSectionComment();
        }
        catch (ContextException e) {
            throw new ProcessingException(this.position, e);
        }
        TemplateCompilerLike.ParameterPartial parameterPartial = this.currentParameterPartial();
        TemplateCompilerLike caller = this.getCaller();
        TemplateCompilerLike.TemplateCompilerType templateType = this.getCompilerType();
        if (parameterPartial != null) {
            if (parameterPartial.getBlockArgs().containsKey(name)) {
                throw new ProcessingException(this.position, "parameter block was defined earlier. block = " + name);
            }
            CodeAppendable.StringCodeAppendable writer = new CodeAppendable.StringCodeAppendable();
            parameterPartial.getBlockArgs().put(name, writer);
            if (this._currentBlockOutput != null) {
                throw new IllegalStateException("existing block output. template: " + this.getTemplateName());
            }
            this._currentBlockOutput = writer;
            if (this.currentWriter() != this._currentBlockOutput) {
                throw new IllegalStateException("unexpected current writer");
            }
            this.print("// start BLOCK parameter. name: \"" + name + "\", template: " + this.getTemplateName() + ", partial: " + parameterPartial.getTemplateName());
            this.println();
        } else if (templateType == TemplateCompilerLike.TemplateCompilerType.PARAM_PARTIAL_TEMPLATE && caller != null) {
            if (this.getCompilerType() == TemplateCompilerLike.TemplateCompilerType.PARAM_PARTIAL_TEMPLATE && caller.currentParameterPartial() == null) {
                throw new IllegalStateException("bug. missing partial parameter info");
            }
            if (this._currentBlockOutput != null) {
                throw new IllegalStateException("existing block output. template: " + this.getTemplateName() + " name: " + name);
            }
            this._currentBlockOutput = new CodeAppendable.StringCodeAppendable();
            this.print("// start BLOCK default. name: \"" + name + "\", template: " + this.getTemplateName());
            this.println();
        } else {
            this.print("// unused block: " + name);
            this.println();
        }
    }

    @Override
    protected void _endSection(String name) throws ProcessingException {
        if (!this.context.isEnclosed()) {
            throw new ProcessingException(this.position, "Closing " + name + " block when no block is currently open");
        }
        if (!this.context.currentEnclosedContextName().equals(name)) {
            throw new ProcessingException(this.position, "Closing " + name + " block instead of " + this.context.currentEnclosedContextName());
        }
        TemplateCompilerContext.ContextType contextType = this.context.getType();
        switch (contextType) {
            case LAMBDA: {
                this._endLambdaSection(name);
                --this.depth;
                break;
            }
            case PARENT_PARTIAL: {
                this.flushUnescaped();
                this._endParentSection(name);
                break;
            }
            case BLOCK: {
                this.flushUnescaped();
                this._endBlockSection(name);
                break;
            }
            case PATH: 
            case ESCAPED_VAR: 
            case UNESCAPED_VAR: 
            case PARTIAL: {
                throw new IllegalStateException("Context Type is wrong. " + this.context.getType());
            }
            case ROOT: 
            case SECTION: 
            case INVERTED: {
                this.flushUnescaped();
                --this.depth;
            }
        }
        this.print(this.context.endSectionRenderingCode());
        this.printEndSectionComment();
        this.context = this.context.parentContext();
    }

    private void _endParentSection(String name) throws ProcessingException {
        this._parentBlockOutput = null;
        TemplateCompilerLike.ParameterPartial p = this.currentParameterPartial();
        if (p == null) {
            throw new IllegalStateException("partial is has not started for this context");
        }
        try (TemplateCompilerLike.ParameterPartial parameterPartial = p;){
            if (this.isDebug()) {
                this.debug("Running partial. " + p);
            }
            p.run();
            this.popPartial();
        }
        catch (IOException e) {
            throw new ProcessingException(this.position, e);
        }
    }

    private void _endBlockSection(String name) {
        switch (this.getCompilerType()) {
            case PARAM_PARTIAL_TEMPLATE: {
                TemplateCompilerLike callingTemplate = this.getCaller();
                if (callingTemplate == null) {
                    throw new IllegalStateException("missing calling template");
                }
                CodeAppendable.StringCodeAppendable output = this._currentBlockOutput;
                if (output == null) {
                    throw new IllegalStateException("Missing block output");
                }
                TemplateCompilerLike.ParameterPartial callingPartial = callingTemplate.currentParameterPartial();
                if (callingPartial == null) {
                    throw new IllegalStateException("missing partial info");
                }
                CodeAppendable.StringCodeAppendable callingBlock = callingPartial.findBlock(name);
                if (callingBlock != null) {
                    output = callingBlock;
                }
                this._currentBlockOutput = null;
                this.currentWriter().print(output.toString());
                this.println();
                if (callingBlock != null) {
                    this.print("// end BLOCK parameter. name: \"" + name + "\", template: " + callingTemplate.getTemplateName() + ", partial: " + callingPartial.getTemplateName());
                    break;
                }
                this.print("// end BLOCK default. name: \"" + name + "\", template: " + this.getTemplateName() + ", partial: " + callingPartial.getTemplateName());
                break;
            }
            case SIMPLE: 
            case PARTIAL_TEMPLATE: 
            case LAMBDA: {
                TemplateCompilerLike.ParameterPartial p = this.currentParameterPartial();
                if (p == null) break;
                if (this._currentBlockOutput == null) {
                    throw new IllegalStateException("should be capturing for the block");
                }
                if (this._currentBlockOutput != p.getBlockArgs().get(name)) {
                    throw new IllegalStateException();
                }
                this._currentBlockOutput = null;
            }
        }
    }

    @Override
    protected void _variable(String name) throws ProcessingException {
        this.indent();
        this.flushUnescaped();
        this.println();
        try {
            TemplateCompilerContext variable = this.context.getChild(name, TemplateCompilerContext.ContextType.ESCAPED_VAR);
            this.print("// variable: " + variable.currentEnclosedContextName());
            this.println();
            this.print(variable.renderingCode());
            this.println();
        }
        catch (ContextException ex) {
            TemplateStack templateStack = this.context.getTemplateStack();
            String message = "Variable not found. var: " + name + ", template: " + templateStack.describeTemplateStack() + " context stack: " + this.context.printStack() + "\n";
            throw new ProcessingException.VariableNotFoundProcessingException(this.position, ex, message);
        }
    }

    @Override
    protected void _partial(String name) throws ProcessingException {
        this.flushUnescaped();
        this.println();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.PARTIAL;
        try {
            this.context = this.context.getChild(name, contextType);
            this.printBeginSectionComment();
            TemplateCompilerLike.ParameterPartial pp = this.currentParameterPartial();
            if (pp != null) {
                throw new IllegalStateException("parent (parameter partial) is already started for this context");
            }
            try (TemplateCompilerLike.Partial p = this.createPartial(name);){
                p.run();
            }
        }
        catch (ContextException | IOException ex) {
            throw new ProcessingException(this.position, ex);
        }
        this.print(this.context.endSectionRenderingCode());
        this.printEndSectionComment();
        this.context = this.context.parentContext();
    }

    @Override
    protected void _unescapedVariable(String name) throws ProcessingException {
        this.indent();
        this.flushUnescaped();
        this.println();
        try {
            TemplateCompilerContext variable = this.context.getChild(name, TemplateCompilerContext.ContextType.UNESCAPED_VAR);
            this.print("// unescaped variable: " + variable.currentEnclosedContextName());
            this.println();
            this.print(variable.unescapedRenderingCode());
            this.println();
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    private void indent() {
        if (this.atStartOfLine) {
            this.printCodeToWrite(this.indent);
        }
    }

    @Override
    protected void _specialCharacter(MustacheToken.SpecialChar specialChar) throws ProcessingException {
        this.printCodeToWrite(specialChar.javaEscaped());
    }

    @Override
    public void _newline(MustacheToken.NewlineChar c) throws ProcessingException {
        this.printCodeToWrite(c.javaEscaped());
    }

    @Override
    public void _text(String s) throws ProcessingException {
        this.indent();
        this.printCodeToWrite(s);
    }

    @Override
    public void _endOfFile() throws ProcessingException {
        this.flushUnescaped();
        if (!this.context.isEnclosed()) {
            return;
        }
        throw new ProcessingException(this.position, "Unclosed \"" + this.context.currentEnclosedContextName() + "\" block at end of file");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static class SimpleTemplateCompiler
    extends RootTemplateCompiler {
        private SimpleTemplateCompiler(String templateName, TemplateCompilerLike.TemplateLoader templateLoader, CodeAppendable writer, TemplateCompilerContext context, Set<Prisms.Flag> flags) throws IOException {
            super(templateName, templateLoader, writer, context, flags);
        }

        @Override
        public void run() throws ProcessingException, IOException {
            boolean suppressesOutput = this.getWriter().suppressesOutput();
            this.getWriter().enableOutput();
            super.run();
            if (suppressesOutput) {
                this.getWriter().disableOutput();
            } else {
                this.getWriter().enableOutput();
            }
        }
    }

    static interface Factory {
        public TemplateCompiler createTemplateCompiler(NamedReader var1, SwitchablePrintWriter var2, TemplateCompilerContext var3);
    }

    static class RootTemplateCompiler
    extends TemplateCompiler {
        private final TemplateCompilerLike.TemplateLoader templateLoader;
        private final CodeAppendable writer;
        private final Set<Prisms.Flag> flags;

        public RootTemplateCompiler(String templateName, TemplateCompilerLike.TemplateLoader templateLoader, CodeAppendable writer, TemplateCompilerContext context, Set<Prisms.Flag> flags) throws IOException {
            super(templateLoader.open(templateName), null, context);
            this.templateLoader = templateLoader;
            this.writer = writer;
            this.flags = flags;
        }

        @Override
        public @Nullable TemplateCompilerLike getCaller() {
            return null;
        }

        @Override
        public TemplateCompilerLike.TemplateLoader getTemplateLoader() {
            return this.templateLoader;
        }

        @Override
        public CodeAppendable getWriter() {
            return this.writer;
        }

        @Override
        public Set<Prisms.Flag> flags() {
            return this.flags;
        }
    }
}

