/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.NamedReader;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

interface TemplateCompilerLike
extends AutoCloseable {
    public void run() throws ProcessingException, IOException;

    @Override
    public void close() throws IOException;

    public TemplateCompilerType getCompilerType();

    public String getTemplateName();

    public @Nullable TemplateCompilerLike getCaller();

    default public TemplateLoader getTemplateLoader() {
        return Objects.requireNonNull(this.getCaller()).getTemplateLoader();
    }

    default public CodeAppendable getWriter() {
        return Objects.requireNonNull(this.getCaller()).getWriter();
    }

    default public Set<Prisms.Flag> flags() {
        return Objects.requireNonNull(this.getCaller()).flags();
    }

    public @Nullable ParameterPartial currentParameterPartial();

    public ParameterPartial createParameterPartial(String var1) throws ProcessingException, IOException;

    public static interface TemplateLoader {
        public NamedReader open(String var1) throws IOException;
    }

    public static class ParameterPartial
    extends AbstractPartial {
        private final Map<String, CodeAppendable.StringCodeAppendable> blockArgs = new LinkedHashMap<String, CodeAppendable.StringCodeAppendable>();

        public ParameterPartial(TemplateCompilerLike templateCompiler) {
            super(templateCompiler);
        }

        public Map<String, CodeAppendable.StringCodeAppendable> getBlockArgs() {
            return this.blockArgs;
        }

        public @Nullable CodeAppendable.StringCodeAppendable findBlock(String name) {
            TemplateCompilerLike caller = this.templateCompiler;
            ArrayDeque<TemplateCompilerLike> callers = new ArrayDeque<TemplateCompilerLike>();
            callers.push(caller);
            while ((caller = caller.getCaller()) != null) {
                callers.push(caller);
            }
            for (TemplateCompilerLike c : callers) {
                CodeAppendable.StringCodeAppendable b;
                ParameterPartial p = c.currentParameterPartial();
                if (p == null || (b = p.getBlockArgs().get(name)) == null) continue;
                return b;
            }
            return null;
        }

        public String toString() {
            return "ParameterPartial(template = " + this.getTemplateName() + " args=" + this.blockArgs + ")";
        }
    }

    public static class Partial
    extends AbstractPartial {
        public Partial(TemplateCompilerLike templateCompiler) {
            super(templateCompiler);
        }

        public String toString() {
            return "Partial(template = " + this.getTemplateName() + ")";
        }
    }

    public static abstract class AbstractPartial
    implements AutoCloseable {
        protected final TemplateCompilerLike templateCompiler;

        public AbstractPartial(TemplateCompilerLike templateCompiler) {
            this.templateCompiler = templateCompiler;
        }

        public String getTemplateName() {
            return this.templateCompiler.getTemplateName();
        }

        void run() throws ProcessingException, IOException {
            this.templateCompiler.run();
        }

        @Override
        public void close() throws IOException {
            this.templateCompiler.close();
        }
    }

    public static enum TemplateCompilerType {
        SIMPLE,
        LAMBDA,
        PARTIAL_TEMPLATE,
        PARAM_PARTIAL_TEMPLATE;

    }
}

