/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.internal.ProcessingConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class TextFileObject {
    private final ProcessingEnvironment env;
    private final ProcessingConfig config;

    TextFileObject(ProcessingConfig config, ProcessingEnvironment env) {
        this.env = env;
        this.config = config;
    }

    InputStream openInputStream(String name) throws IOException {
        FileObject resource = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", name);
        if (resource.getLastModified() > 0L) {
            return resource.openInputStream();
        }
        if (this.config.isDebug()) {
            this.config.debug("File not found with Filer. resource: " + resource.toUri());
        }
        if (this.config.fallbackToFilesystem()) {
            Path projectPath;
            FileObject dummy = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "dummy");
            if (this.config.isGradle()) {
                if (this.config.isDebug()) {
                    this.config.debug("Looks like we are using Gradle incremental. dummy: " + dummy.toUri());
                }
                projectPath = Paths.get(dummy.toUri()).getParent().getParent().getParent().getParent().getParent();
            } else {
                if (this.config.isDebug()) {
                    this.config.debug("Looks like we are using Eclipse incremental. dummy: " + dummy.toUri());
                }
                projectPath = Paths.get(dummy.toUri()).getParent().getParent().getParent();
            }
            Path filePath = Path.of(this.config.resourcesPath(), name);
            Path fullPath = projectPath.resolve(filePath);
            if (this.config.isDebug()) {
                this.config.debug("File not found with Filer. Trying direct file access. name:" + name + ", path: " + fullPath + ", dummy: " + dummy.toUri());
            }
            return Files.newInputStream(fullPath, new OpenOption[0]);
        }
        return resource.openInputStream();
    }

    Charset charset() {
        return this.config.charset();
    }
}

