/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public interface FormatterTypes {
    public boolean isMatch(String var1);

    public static FormatterTypes acceptOnlyKnownTypes() {
        return new FormatterTypes(){

            @Override
            public boolean isMatch(String className) {
                return false;
            }
        };
    }

    public static enum FormatCallType {
        STACHE,
        JSTACHIO;

    }

    public static class ConfiguredFormatterTypes
    implements FormatterTypes {
        private final List<String> classNames;
        private final List<Pattern> patterns;

        public ConfiguredFormatterTypes(List<String> classNames, List<String> classPatterns) {
            this.classNames = classNames;
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String p : classPatterns) {
                patterns.add(Pattern.compile(p));
            }
            this.patterns = List.copyOf(patterns);
        }

        @Override
        public boolean isMatch(String className) {
            if (this.classNames.isEmpty() && this.patterns.isEmpty()) {
                return true;
            }
            for (String n : this.classNames) {
                if (!n.equals(className)) continue;
                return true;
            }
            for (Pattern p : this.patterns) {
                if (!p.matcher(className).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

