/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import org.eclipse.jdt.annotation.Nullable;

class ArrayRenderingContext
implements RenderingContext {
    private final JavaExpression arrayExpression;
    private final String indexVariableName;
    private final RenderingContext parent;

    public ArrayRenderingContext(JavaExpression arrayExpression, String indexVariableName, RenderingContext parent) {
        this.arrayExpression = arrayExpression;
        this.indexVariableName = indexVariableName;
        this.parent = parent;
    }

    @Override
    public String beginSectionRenderingCode() {
        return this.parent.beginSectionRenderingCode() + String.format("for (int %s = 0; %s < %s; %s++) { ", this.indexVariableName, this.indexExpression().text(), this.arrayExpression.arrayLength().text(), this.indexExpression().text());
    }

    @Override
    public String endSectionRenderingCode() {
        return "}" + this.parent.endSectionRenderingCode();
    }

    JavaExpression componentExpession() {
        return this.arrayExpression.subscript(this.indexExpression());
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return null;
    }

    @Override
    public JavaExpression currentExpression() {
        return this.arrayExpression;
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    private JavaExpression indexExpression() {
        return this.arrayExpression.model().expression(this.indexVariableName, this.arrayExpression.model().knownTypes()._int);
    }

    @Override
    public @Nullable RenderingContext getParent() {
        return this.parent;
    }
}

