/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.InvertedExpressionContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

class DeclaredTypeRenderingContext
implements RenderingContext,
InvertedExpressionContext {
    private final JavaExpression expression;
    private final TypeElement definitionElement;
    private final RenderingContext parent;

    DeclaredTypeRenderingContext(JavaExpression expression, TypeElement element, RenderingContext parent) {
        this.expression = expression;
        this.definitionElement = element;
        this.parent = parent;
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        List<? extends Element> enclosedElements = this.definitionElement.getEnclosedElements();
        List<? extends Element> all = JavaLanguageModel.getInstance().getElements().getAllMembers(this.definitionElement);
        List<ExecutableElement> methods = ElementFilter.methodsIn(all).stream().filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getReturnType().getKind() != TypeKind.VOID && e.getParameters().isEmpty()).toList();
        ArrayList<ExecutableElement> allMethods = new ArrayList<ExecutableElement>();
        allMethods.addAll(ElementFilter.methodsIn(enclosedElements));
        allMethods.addAll(methods);
        JavaExpression result = this.getMethodEntry(allMethods, name);
        if (result != null) {
            return result;
        }
        result = this.getMethodEntry(allMethods, this.getterName(name));
        if (result != null) {
            return result;
        }
        result = this.getFieldEntry(enclosedElements, name);
        return result;
    }

    @Override
    public @Nullable JavaExpression find(String name, Predicate<RenderingContext> filter) throws ContextException {
        JavaExpression result = null;
        if (filter.test(this)) {
            result = this.get(name);
        }
        if (result == null) {
            result = this.parent.find(name, filter);
        }
        return result;
    }

    private @Nullable JavaExpression getMethodEntry(List<? extends Element> elements, String methodName) throws ContextException {
        boolean nameFound = false;
        for (Element element : elements) {
            ExecutableType method;
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(methodName)) continue;
            nameFound = true;
            try {
                method = this.expression.methodSignature(element);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unable to get " + element + " method signature for " + this.expression.type() + " type, defined at " + this.definitionElement, ex);
            }
            if (!method.getParameterTypes().isEmpty()) continue;
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new ContextException(MessageFormat.format("Refence to private method: ''{0}'': use package (default) access modifier to access method instead", methodName));
            }
            if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new ContextException(MessageFormat.format("Refence to static method: ''{0}'': only instance methods are accessible", methodName));
            }
            if (!this.areUnchecked(method.getThrownTypes())) {
                throw new ContextException(MessageFormat.format("Refence to method throwing checked exceptions: ''{0}'': only unchecked exceptions are allowed", methodName));
            }
            return this.expression.methodCall(element, new JavaExpression[0]);
        }
        if (!nameFound) {
            return null;
        }
        return null;
    }

    private @Nullable JavaExpression getFieldEntry(List<? extends Element> enclosedElements, String name) throws ContextException {
        for (Element element : enclosedElements) {
            if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().contentEquals(name)) continue;
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new ContextException(MessageFormat.format("Refence to private field: ''{0}'': use package (default) access modifier to access field instead", name));
            }
            if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new ContextException(MessageFormat.format("Refence to static field: ''{0}'': only instance fields are accessible", name));
            }
            return this.expression.fieldAccess(element);
        }
        return null;
    }

    private String getterName(String name) {
        return "get" + name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
    }

    private boolean areUnchecked(List<? extends TypeMirror> thrownTypes) {
        for (TypeMirror typeMirror : thrownTypes) {
            if (this.expression.model().isUncheckedException(typeMirror)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JavaExpression currentExpression() {
        return this.expression;
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    @Override
    public @Nullable RenderingContext getParent() {
        return this.parent;
    }

    @Override
    public String invertedExpression() {
        return "(" + this.currentExpression().text() + " == null )";
    }

    @Override
    public String description() {
        return this.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [\n\t\texpression=" + this.expression + ",\n\t\tdefinitionElement=" + this.definitionElement + ",\n\t\tparent=" + this.parent + "]";
    }
}

