/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.util.Interpolator;
import java.util.Map;
import java.util.function.Predicate;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.eclipse.jdt.annotation.Nullable;

class IterableRenderingContext
implements RenderingContext {
    private final JavaExpression expression;
    private final String elementVariableName;
    private final String indexVariableName;
    private final RenderingContext parent;
    private final String iteratorVariableName;

    public IterableRenderingContext(JavaExpression expression, String elementVariableName, String indexVariableName, RenderingContext parent) {
        this.expression = expression;
        this.elementVariableName = elementVariableName;
        this.indexVariableName = indexVariableName;
        this.iteratorVariableName = elementVariableName + "It";
        this.parent = parent;
    }

    @Override
    public String beginSectionRenderingCode() {
        String loop = "\nint ${i} = 0;\nfor (java.util.Iterator<? extends ${elementGeneric}> ${iteratorVar} = ${iterableVar}.iterator(); ${iteratorVar}.hasNext(); ${i}++) {\n    ${elementType} ${elementVar} = ${iteratorVar}.next();\n";
        Map<String, String> names = Map.of("i", this.indexVariableName, "elementGeneric", this.elementExpession().type().toString().toString(), "elementType", this.elementExpession().type().toString(), "elementVar", this.elementVariableName, "iteratorVar", this.iteratorVariableName, "iterableVar", this.expression.text());
        loop = Interpolator.of().interpolate(loop, names::get);
        return this.parent.beginSectionRenderingCode() + loop;
    }

    @Override
    public String endSectionRenderingCode() {
        return " }" + this.parent.endSectionRenderingCode();
    }

    @Override
    public @Nullable JavaExpression find(String name, Predicate<RenderingContext> filter) throws ContextException {
        return switch (name) {
            case "-first", "-last", "@first", "@last", "-index", "@index" -> this.get(name);
            default -> RenderingContext.super.find(name, filter);
        };
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return switch (name) {
            case "-first", "@first" -> this.first();
            case "-last", "@last" -> this.last();
            case "-index" -> this.oneBasedIndex();
            case "@index" -> this.zeroBasedIndex();
            default -> this.parent.get(name);
        };
    }

    JavaExpression first() {
        JavaLanguageModel model = this.expression.model();
        return model.expression("(" + this.indexVariableName + " == 0 )", model.knownTypes()._boolean);
    }

    JavaExpression last() {
        JavaLanguageModel model = this.expression.model();
        return model.expression("( ! " + this.iteratorVariableName + ".hasNext() )", model.knownTypes()._boolean);
    }

    JavaExpression oneBasedIndex() {
        JavaLanguageModel model = this.expression.model();
        return model.expression("( " + this.indexVariableName + " + 1 )", model.knownTypes()._int);
    }

    JavaExpression zeroBasedIndex() {
        JavaLanguageModel model = this.expression.model();
        return model.expression(this.indexVariableName, model.knownTypes()._int);
    }

    @Override
    public JavaExpression currentExpression() {
        return this.expression;
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    JavaExpression elementExpession() {
        WildcardType wildcardType;
        DeclaredType iterableType = this.expression.model().getSupertype((DeclaredType)this.expression.type(), this.expression.model().knownTypes()._Iterable);
        if (iterableType == null) {
            throw new IllegalStateException("expected iterable type. bug.");
        }
        TypeMirror elementType = iterableType.getTypeArguments().iterator().next();
        if (elementType instanceof WildcardType && (elementType = (wildcardType = (WildcardType)elementType).getExtendsBound()) == null) {
            throw new IllegalStateException("expected upper bounds. bug.");
        }
        return this.expression.model().expression(this.elementVariableName, elementType);
    }

    @Override
    public @Nullable RenderingContext getParent() {
        return this.parent;
    }
}

