/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.TypeException;
import io.jstach.apt.internal.context.types.KnownType;
import io.jstach.apt.internal.context.types.KnownTypes;
import io.jstach.apt.internal.context.types.NativeType;
import io.jstach.apt.internal.context.types.ObjectType;
import io.jstach.apt.internal.context.types.TypesMixin;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.eclipse.jdt.annotation.Nullable;

public class JavaLanguageModel
implements TypesMixin {
    private static @Nullable JavaLanguageModel INSTANCE;
    private final Types operations;
    private final Elements elements;
    private final Messager messager;
    private final KnownTypes knownTypes;

    public static JavaLanguageModel createInstance(Types types, Elements elements, Messager messager) {
        JavaLanguageModel self;
        KnownTypes knownTypes = KnownTypes.createInstace(elements, types);
        INSTANCE = self = new JavaLanguageModel(types, elements, messager, knownTypes);
        return self;
    }

    public static JavaLanguageModel getInstance() {
        return Objects.requireNonNull(INSTANCE);
    }

    JavaLanguageModel(Types operations, Elements elements, Messager messager, KnownTypes knownTypes) {
        this.operations = operations;
        this.knownTypes = knownTypes;
        this.elements = elements;
        this.messager = messager;
    }

    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Types getTypes() {
        return this.operations;
    }

    public Elements getElements() {
        return this.elements;
    }

    public KnownTypes knownTypes() {
        return this.knownTypes;
    }

    boolean isUncheckedException(TypeMirror exceptionType) {
        return this.operations.isAssignable(exceptionType, this.operations.getDeclaredType(this.knownTypes._Error.typeElement(), new TypeMirror[0])) || this.operations.isAssignable(exceptionType, this.operations.getDeclaredType(this.knownTypes._RuntimeException.typeElement(), new TypeMirror[0]));
    }

    JavaExpression expression(String text, NativeType type) {
        return new JavaExpression(this, text, type.typeMirror(), List.of());
    }

    JavaExpression expression(String text, TypeMirror type) {
        return new JavaExpression(this, text, type, List.of());
    }

    String eraseType(DeclaredType dt) {
        return this.operations.erasure(dt).toString();
    }

    TypeMirror getGenericDeclaredType(TypeElement element) {
        List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
        int numberOfParameters = typeParameters.size();
        ArrayList<WildcardType> typeArguments = new ArrayList<WildcardType>(numberOfParameters);
        for (int i = 0; i < numberOfParameters; ++i) {
            typeArguments.add(this.operations.getWildcardType(null, null));
        }
        TypeMirror[] typeArgumentArray = new TypeMirror[typeArguments.size()];
        typeArgumentArray = typeArguments.toArray(typeArgumentArray);
        return this.getDeclaredType(element, typeArgumentArray);
    }

    @Nullable DeclaredType getSupertype(DeclaredType type, ObjectType supertypeDeclaration) {
        return this.getSupertype(type, supertypeDeclaration.typeElement());
    }

    @Nullable DeclaredType getSupertype(DeclaredType type, TypeElement supertypeDeclaration) {
        if (type.asElement().equals(supertypeDeclaration)) {
            return type;
        }
        List<? extends TypeMirror> supertypes = this.operations.directSupertypes(type);
        for (TypeMirror typeMirror : supertypes) {
            DeclaredType result = this.getSupertype((DeclaredType)typeMirror, supertypeDeclaration);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    TypeElement asElement(DeclaredType declaredType) {
        return Objects.requireNonNull((TypeElement)this.operations.asElement(declaredType));
    }

    boolean isType(TypeMirror type, KnownType knownType) {
        if (knownType instanceof NativeType) {
            NativeType nativeType = (NativeType)knownType;
            return this.isSameType(type, nativeType.typeMirror());
        }
        if (knownType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)knownType;
            return this.isSubtype(type, this.getDeclaredType(objectType.typeElement(), new TypeMirror[0]));
        }
        throw new IllegalStateException();
    }

    public Optional<KnownType> resolveType(TypeMirror type) throws TypeException {
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            TypeMirror eb = wt.getExtendsBound();
            if (eb == null) {
                return Optional.empty();
            }
            return this.resolveType(eb);
        }
        for (NativeType nt : this.knownTypes.getNativeTypes()) {
            if (!this.isType(type, nt)) continue;
            return Optional.of(nt);
        }
        for (ObjectType ot : this.knownTypes.getObjectTypes()) {
            if (!this.isType(type, ot)) continue;
            return Optional.of(ot);
        }
        return Optional.empty();
    }
}

