/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.InvertedExpressionContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

class MapRenderingContext
implements RenderingContext,
InvertedExpressionContext {
    protected final JavaExpression expression;
    protected final TypeElement definitionElement;
    private final RenderingContext parent;

    MapRenderingContext(JavaExpression expression, TypeElement element, RenderingContext parent) {
        this.expression = expression;
        this.definitionElement = element;
        this.parent = parent;
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        if (name.equals(".")) {
            return this.currentExpression();
        }
        List<? extends Element> all = this.expression.model().getElements().getAllMembers(this.definitionElement);
        ExecutableElement getMethod = ElementFilter.methodsIn(all).stream().filter(e -> "get".equals(e.getSimpleName().toString()) && e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getReturnType().getKind() != TypeKind.VOID && e.getParameters().size() == 1).findFirst().orElse(null);
        if (getMethod == null) {
            return null;
        }
        return this.expression.mapGet(getMethod, name);
    }

    @Override
    public @Nullable JavaExpression find(String name, Predicate<RenderingContext> filter) throws ContextException {
        JavaExpression r = this.parent.find(name, filter.and(c -> !(c instanceof MapRenderingContext)));
        if (r == null && filter.test(this)) {
            r = this.get(name);
        }
        return r;
    }

    @Override
    public JavaExpression currentExpression() {
        return this.expression;
    }

    @Override
    public String invertedExpression() {
        return "( " + this.expression.text() + " == null )";
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    @Override
    public @Nullable RenderingContext getParent() {
        return this.parent;
    }
}

