/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

class OptionalRenderingContext
implements RenderingContext {
    private final JavaExpression expression;
    private final TypeElement definitionElement;
    private final RenderingContext parent;

    OptionalRenderingContext(JavaExpression expression, TypeElement element, RenderingContext parent) {
        this.expression = expression;
        this.definitionElement = element;
        this.parent = parent;
    }

    @Override
    public String beginSectionRenderingCode() {
        return this.parent.beginSectionRenderingCode() + "if ( " + this.toNullableExpression().text() + " != null ) {";
    }

    @Override
    public String endSectionRenderingCode() {
        return this.parent.endSectionRenderingCode() + "}";
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return null;
    }

    @Override
    public JavaExpression currentExpression() {
        return this.toNullableExpression();
    }

    private JavaExpression toNullableExpression() {
        List<? extends Element> all = this.expression.model().getElements().getAllMembers(this.definitionElement);
        ExecutableElement getMethod = ElementFilter.methodsIn(all).stream().filter(e -> "orElse".equals(e.getSimpleName().toString()) && e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getReturnType().getKind() != TypeKind.VOID && e.getParameters().size() == 1).findFirst().orElse(null);
        if (getMethod == null) {
            throw new IllegalStateException("bug in optional");
        }
        return this.expression.optionalOrElseNull(getMethod);
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    @Override
    public @Nullable RenderingContext getParent() {
        return this.parent;
    }
}

