/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.context.ArrayRenderingContext;
import io.jstach.apt.internal.context.BooleanRenderingContext;
import io.jstach.apt.internal.context.ContextNodeRenderingContext;
import io.jstach.apt.internal.context.DeclaredTypeRenderingContext;
import io.jstach.apt.internal.context.EnumRenderingContext;
import io.jstach.apt.internal.context.InvertedExpressionContext;
import io.jstach.apt.internal.context.IterableRenderingContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.Lambda;
import io.jstach.apt.internal.context.ListRenderingContext;
import io.jstach.apt.internal.context.MapRenderingContext;
import io.jstach.apt.internal.context.NoDataContext;
import io.jstach.apt.internal.context.OptionalRenderingContext;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.RootRenderingContext;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.context.TypeException;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.context.VariablesRenderingContext;
import io.jstach.apt.internal.context.types.KnownType;
import io.jstach.apt.internal.context.types.KnownTypes;
import io.jstach.apt.internal.context.types.NativeType;
import io.jstach.apt.internal.context.types.ObjectType;
import io.jstach.apt.prism.JStacheLambdaPrism;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.NonNull;

public class RenderingCodeGenerator {
    private final KnownTypes knownTypes;
    private final JavaLanguageModel javaModel;
    private final FormatterTypes formatterTypes;
    private final FormatterTypes.FormatCallType formatCallType;
    private boolean USE_LIST_CONTEXT = Boolean.getBoolean("USE_LIST_CONTEXT");

    public static RenderingCodeGenerator createInstance(JavaLanguageModel javaModel, FormatterTypes formatterTypes, FormatterTypes.FormatCallType formatCallType) {
        return new RenderingCodeGenerator(javaModel.knownTypes(), javaModel, formatterTypes, formatCallType);
    }

    private RenderingCodeGenerator(KnownTypes types, JavaLanguageModel javaModel, FormatterTypes formatterTypes, FormatterTypes.FormatCallType formatCallType) {
        this.knownTypes = types;
        this.javaModel = javaModel;
        this.formatterTypes = formatterTypes;
        this.formatCallType = formatCallType;
    }

    String generateRenderingCode(JavaExpression expression, VariableContext variables, String path) throws TypeException {
        DeclaredType dt;
        String cname;
        TypeMirror type = expression.type();
        String text = expression.text();
        if (type instanceof WildcardType) {
            return this.generateRenderingCode(this.javaModel.expression(text, ((WildcardType)type).getExtendsBound()), variables, path);
        }
        KnownType knownType = this.javaModel.resolveType(type).orElse(null);
        if (knownType != null && (knownType instanceof NativeType || knownType.equals(this.knownTypes._String))) {
            return this.renderFormatCall(variables, path, text);
        }
        if (knownType != null && knownType instanceof ObjectType) {
            String cname2 = knownType.renderClassName() + ".class";
            return this.renderFormatCall(variables, path, text, cname2);
        }
        if (type instanceof DeclaredType && this.formatterTypes.isMatch(cname = this.javaModel.eraseType(dt = (DeclaredType)type))) {
            return this.renderFormatCall(variables, path, text, cname + ".class");
        }
        throw new TypeException(MessageFormat.format("Can''t render {0} expression of {1} type as it is not an allowed type to format. ", text, type));
    }

    private String renderFormatCall(VariableContext variables, String path, String text, String cname) {
        return switch (this.formatCallType) {
            default -> throw new IncompatibleClassChangeError();
            case FormatterTypes.FormatCallType.JSTACHIO -> this.renderFormatCallJStache(variables, path, text, cname);
            case FormatterTypes.FormatCallType.STACHE -> this.renderFormatCallStache(variables, text);
        };
    }

    private String renderFormatCall(VariableContext variables, String path, String text) {
        return switch (this.formatCallType) {
            default -> throw new IncompatibleClassChangeError();
            case FormatterTypes.FormatCallType.JSTACHIO -> this.renderFormatCallJStache(variables, path, text);
            case FormatterTypes.FormatCallType.STACHE -> this.renderFormatCallStache(variables, text);
        };
    }

    private String renderFormatCallJStache(VariableContext variables, String path, String text) {
        return variables.formatter() + ".format(" + variables.escaper() + ", " + variables.unescapedWriter() + ", \"" + path + "\", " + text + ");";
    }

    private String renderFormatCallJStache(VariableContext variables, String path, String text, String cname) {
        return variables.formatter() + ".format(" + variables.escaper() + ", " + variables.unescapedWriter() + ", \"" + path + "\", " + cname + ", " + text + ");";
    }

    private String renderFormatCallStache(VariableContext variables, String text) {
        String fmt = variables.formatter() + ".apply(" + text + ")";
        if (variables.isEscaped()) {
            fmt = variables.escaper() + ".apply(" + fmt + ")";
        }
        return variables.unescapedWriter() + ".append(" + fmt + ");";
    }

    private Lambda.Lambdas resolveLambdas(TypeElement element, JavaExpression root) throws AnnotatedException {
        List<? extends Element> all = this.javaModel.getElements().getAllMembers(element);
        List<ExecutableElement> lambdaMethods = ElementFilter.methodsIn(all).stream().filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getReturnType().getKind() != TypeKind.VOID).filter(e -> JStacheLambdaPrism.getInstanceOn(e) != null).toList();
        LinkedHashMap<String, Lambda> lambdas = new LinkedHashMap<String, Lambda>();
        for (ExecutableElement lm : lambdaMethods) {
            Lambda lambda;
            JStacheLambdaPrism p = JStacheLambdaPrism.getInstanceOn(lm);
            String name = p.name();
            try {
                lambda = Lambda.of(root, lm, name);
            }
            catch (Exception e1) {
                throw new AnnotatedException(e1.getMessage(), lm);
            }
            lambdas.put(lambda.name(), lambda);
        }
        return new Lambda.Lambdas(lambdas);
    }

    public TemplateCompilerContext createTemplateCompilerContext(TemplateStack templateStack, TypeElement element, String expression, VariableContext variables) throws AnnotatedException {
        JavaExpression javaExpression = this.javaModel.expression(expression, this.javaModel.getDeclaredType(element, new TypeMirror[0]));
        RootRenderingContext root = new RootRenderingContext(variables);
        Lambda.Lambdas lambdas = this.resolveLambdas(element, javaExpression);
        InvertedExpressionContext rootRenderingContext = this.javaModel.isType(element.asType(), this.knownTypes._MapNode) ? new ContextNodeRenderingContext(javaExpression, element, root) : (this.javaModel.isType(element.asType(), this.knownTypes._Map) ? new MapRenderingContext(javaExpression, element, root) : new DeclaredTypeRenderingContext(javaExpression, element, root));
        return new TemplateCompilerContext(templateStack, lambdas, this, variables, (RenderingContext)((Object)rootRenderingContext), TemplateCompilerContext.ContextType.ROOT);
    }

    public TemplateCompilerContext createTemplateCompilerContext(TemplateStack templateStack, DeclaredType type, String expression, VariableContext variables) throws AnnotatedException {
        TypeElement element = this.javaModel.asElement(type);
        return this.createTemplateCompilerContext(templateStack, element, expression, variables);
    }

    RenderingContext createRenderingContext(TemplateCompilerContext.ContextType childType, JavaExpression expression, RenderingContext enclosing) throws TypeException {
        if (this.knownTypes._MapNode.isType(expression.type())) {
            return switch (childType) {
                case TemplateCompilerContext.ContextType.SECTION -> this.createIterableContext(childType, expression, enclosing);
                default -> this.createMapNodeContext(expression, enclosing);
            };
        }
        if (expression.type() instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)expression.type();
            TypeMirror extendsBound = wildcardType.getExtendsBound();
            return this.createRenderingContext(childType, this.javaModel.expression(expression.text(), extendsBound), enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._boolean) && !childType.isVar()) {
            return new BooleanRenderingContext(expression.text(), enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Boolean) && !childType.isVar()) {
            RenderingContext nullableContext = this.nullableRenderingContext(expression, enclosing);
            BooleanRenderingContext booleanContext = new BooleanRenderingContext(expression.text(), nullableContext);
            return booleanContext;
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Optional)) {
            return this.createOptionalContext(childType, expression, enclosing);
        }
        if (this.USE_LIST_CONTEXT && this.javaModel.isType(expression.type(), this.knownTypes._List)) {
            RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
            VariableContext variableContext = nullable.createEnclosedVariableContext();
            String indexVariableName = variableContext.introduceNewNameLike("i");
            VariablesRenderingContext variables = new VariablesRenderingContext(variableContext, nullable);
            ListRenderingContext list = new ListRenderingContext(expression, indexVariableName, variables);
            return this.createRenderingContext(childType, list.componentExpession(), list);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Iterable)) {
            return this.createIterableContext(childType, expression, enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Map)) {
            return this.createMapContext(expression, enclosing);
        }
        if (expression.type().getKind() == TypeKind.ARRAY) {
            RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
            VariableContext variableContext = nullable.createEnclosedVariableContext();
            String indexVariableName = variableContext.introduceNewNameLike("i");
            VariablesRenderingContext variables = new VariablesRenderingContext(variableContext, nullable);
            ArrayRenderingContext array = new ArrayRenderingContext(expression, indexVariableName, variables);
            return this.createRenderingContext(childType, array.componentExpession(), array);
        }
        if (expression.type().getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)expression.type();
            RenderingContext parent = switch (childType) {
                case TemplateCompilerContext.ContextType.ESCAPED_VAR, TemplateCompilerContext.ContextType.UNESCAPED_VAR -> enclosing;
                case TemplateCompilerContext.ContextType.SECTION, TemplateCompilerContext.ContextType.PATH, TemplateCompilerContext.ContextType.INVERTED, TemplateCompilerContext.ContextType.PARENT_PARTIAL -> this.nullableRenderingContext(expression, enclosing);
                case TemplateCompilerContext.ContextType.ROOT -> throw new UnsupportedOperationException("Unimplemented case: " + childType);
                default -> throw new IllegalArgumentException("Unexpected value: " + childType);
            };
            return this.createDeclaredContext(expression, declaredType, parent);
        }
        return new NoDataContext(expression, enclosing);
    }

    private DeclaredTypeRenderingContext createDeclaredContext(JavaExpression expression, DeclaredType declaredType, RenderingContext parent) {
        TypeElement typeElement = this.javaModel.asElement(declaredType);
        DeclaredTypeRenderingContext declaredContext = this.knownTypes._Enum.isType(declaredType) ? new EnumRenderingContext(expression, typeElement, parent) : new DeclaredTypeRenderingContext(expression, typeElement, parent);
        return declaredContext;
    }

    private RenderingContext createOptionalContext(TemplateCompilerContext.ContextType childType, JavaExpression expression, RenderingContext enclosing) throws TypeException {
        DeclaredType declaredType = (DeclaredType)expression.type();
        OptionalRenderingContext optional = new OptionalRenderingContext(expression, this.javaModel.asElement(declaredType), enclosing);
        return this.createRenderingContext(childType, optional.currentExpression(), optional);
    }

    private RenderingContext createMapContext(JavaExpression expression, RenderingContext enclosing) {
        RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
        DeclaredType mapType = (DeclaredType)expression.type();
        MapRenderingContext map = new MapRenderingContext(expression, this.javaModel.asElement(mapType), nullable);
        return map;
    }

    private RenderingContext createMapNodeContext(JavaExpression expression, RenderingContext enclosing) {
        RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
        DeclaredType mapType = (DeclaredType)expression.type();
        ContextNodeRenderingContext map = new ContextNodeRenderingContext(expression, this.javaModel.asElement(mapType), nullable);
        return map;
    }

    private RenderingContext createIterableContext(TemplateCompilerContext.ContextType childType, JavaExpression expression, RenderingContext enclosing) throws TypeException {
        RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
        VariableContext variableContext = nullable.createEnclosedVariableContext();
        String elementVariableName = variableContext.introduceNewNameLike("element");
        String indexVariableName = variableContext.introduceNewNameLike("i");
        VariablesRenderingContext variables = new VariablesRenderingContext(variableContext, nullable);
        IterableRenderingContext iterable = new IterableRenderingContext(expression, elementVariableName, indexVariableName, variables);
        if (expression.model().isType(expression.type(), this.knownTypes._MapNode)) {
            return this.createMapNodeContext(iterable.elementExpession(), iterable);
        }
        return this.createRenderingContext(childType, iterable.elementExpession(), iterable);
    }

    RenderingContext createInvertedRenderingContext(JavaExpression expression, RenderingContext enclosing) throws TypeException {
        Object c;
        TypeMirror optionalContext2;
        if (this.knownTypes._Iterable.isType(expression.type()) && !this.knownTypes._MapNode.isType(expression.type())) {
            return new BooleanRenderingContext("(" + expression.text() + " == null ) || ! " + expression.text() + ".iterator().hasNext()", enclosing);
        }
        if (expression.type() instanceof WildcardType) {
            throw new IllegalStateException("bug");
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._boolean)) {
            return new BooleanRenderingContext("!(" + expression.text() + ")", enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Boolean)) {
            return new BooleanRenderingContext("(" + expression.text() + ") == null || !(" + expression.text() + ")", enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Optional)) {
            RenderingContext optionalContext2 = this.createOptionalContext(TemplateCompilerContext.ContextType.INVERTED, expression, enclosing);
            return new BooleanRenderingContext("(" + expression.text() + ".isEmpty())", optionalContext2);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._MapNode) && (optionalContext2 = expression.type()) instanceof DeclaredType) {
            @NonNull DeclaredType dt = (DeclaredType)optionalContext2;
            c = new ContextNodeRenderingContext(expression, this.javaModel.asElement(dt), enclosing);
            return new BooleanRenderingContext(this.knownTypes._MapNode.typeElement().getQualifiedName().toString() + ".isFalsey(" + expression.text() + ")", (RenderingContext)c);
        }
        c = expression.type();
        if (c instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)c;
            DeclaredTypeRenderingContext declaredContext = this.createDeclaredContext(expression, dt, enclosing);
            String nullable = "(" + expression.text() + ") == null";
            if (this.knownTypes._Object.isSameType(dt)) {
                nullable = " || Boolean.FALSE.equals(" + expression.text() + ")";
            }
            return new BooleanRenderingContext(nullable, declaredContext);
        }
        if (expression.type() instanceof ArrayType) {
            return new BooleanRenderingContext("(" + expression.text() + ") == null || (" + expression.text() + ").length == 0", enclosing);
        }
        throw new TypeException(MessageFormat.format("Can''t invert {0} expression of {1} type", expression.text(), expression.type()));
    }

    private RenderingContext nullableRenderingContext(JavaExpression expression, RenderingContext context) {
        if (this.javaModel.isSameType(expression.type(), this.knownTypes._Object.typeElement().asType())) {
            return new BooleanRenderingContext(expression.text() + " != null && ! Boolean.FALSE.equals(" + expression.text() + ")", context);
        }
        return new BooleanRenderingContext(expression.text() + " != null", context);
    }
}

