/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.VariableContext;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;

interface RenderingContext {
    default public String beginSectionRenderingCode() {
        RenderingContext p = this.getParent();
        if (p != null) {
            return p.beginSectionRenderingCode();
        }
        return "";
    }

    default public String endSectionRenderingCode() {
        RenderingContext p = this.getParent();
        if (p != null) {
            return p.endSectionRenderingCode();
        }
        return "";
    }

    public @Nullable JavaExpression get(String var1) throws ContextException;

    default public JavaExpression get() {
        return this.currentExpression();
    }

    default public @Nullable JavaExpression find(String name, Predicate<RenderingContext> filter) throws ContextException {
        JavaExpression result = null;
        RenderingContext p = this.getParent();
        if (p != null) {
            result = p.find(name, filter);
        }
        return result;
    }

    public JavaExpression currentExpression();

    public VariableContext createEnclosedVariableContext();

    public @Nullable RenderingContext getParent();

    default public String printStack() {
        StringBuilder sb = new StringBuilder();
        for (RenderingContext parent = this; parent != null; parent = parent.getParent()) {
            sb.append("\n\t<- ");
            sb.append(parent.description());
        }
        return sb.toString();
    }

    default public String description() {
        return this.getClass().getName();
    }
}

