/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.EnclosedRelation;
import io.jstach.apt.internal.context.InvertedRenderingContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.Lambda;
import io.jstach.apt.internal.context.LambdaContext;
import io.jstach.apt.internal.context.LambdaRenderingContext;
import io.jstach.apt.internal.context.MapRenderingContext;
import io.jstach.apt.internal.context.OwnedRenderingContext;
import io.jstach.apt.internal.context.RenderingCodeGenerator;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.context.TypeException;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.annotation.Nullable;

public class TemplateCompilerContext {
    private final TemplateStack templateStack;
    private final Lambda.Lambdas lambdas;
    private final @Nullable EnclosedRelation enclosedRelation;
    private final RenderingContext context;
    private final RenderingCodeGenerator generator;
    private final VariableContext variables;
    private final ContextType childType;

    TemplateCompilerContext(TemplateStack templateStack, Lambda.Lambdas lambdas, RenderingCodeGenerator processor, VariableContext variables, RenderingContext field, ContextType childType) {
        this(templateStack, lambdas, processor, variables, field, childType, null);
    }

    private TemplateCompilerContext(TemplateStack templateStack, Lambda.Lambdas lambdas, RenderingCodeGenerator processor, VariableContext variables, RenderingContext field, ContextType childType, @Nullable EnclosedRelation parent) {
        this.templateStack = templateStack;
        this.lambdas = lambdas;
        this.enclosedRelation = parent;
        this.context = field;
        this.generator = processor;
        this.variables = variables;
        this.childType = childType;
    }

    private String sectionBodyRenderingCode(VariableContext variables) throws ContextException {
        JavaExpression entry = this.context.currentExpression();
        EnclosedRelation er = this.enclosedRelation;
        String path = er != null ? er.name() : "";
        try {
            return this.generator.generateRenderingCode(entry, variables, path);
        }
        catch (TypeException ex) {
            throw new ContextException("Unable to render field", ex);
        }
    }

    public String renderingCode() throws ContextException {
        return this.beginSectionRenderingCode() + this.sectionBodyRenderingCode(this.variables) + this.endSectionRenderingCode();
    }

    public String unescapedRenderingCode() throws ContextException {
        return this.beginSectionRenderingCode() + this.sectionBodyRenderingCode(this.variables.unescaped()) + this.endSectionRenderingCode();
    }

    public String lambdaRenderingCode(String rawBody, String javaCode, LambdaCompiler compiler) throws ContextException, IOException, AnnotatedException, ProcessingException {
        RenderingContext renderingContext = this.context;
        if (renderingContext instanceof LambdaRenderingContext) {
            JavaExpression entry;
            LambdaRenderingContext lc = (LambdaRenderingContext)renderingContext;
            Lambda lm = lc.getLambda();
            LambdaContext ctx = new LambdaContext(lc);
            try {
                entry = lm.callExpression(javaCode, ctx);
            }
            catch (TypeException e) {
                throw new ContextException(e.getMessage(), e);
            }
            return switch (lm.method().returnType()) {
                default -> throw new IncompatibleClassChangeError();
                case Lambda.ReturnType.RAW_STRING -> this.variables.unescapedWriter() + ".append(" + entry.text() + ");";
                case Lambda.ReturnType.MODEL -> {
                    DeclaredType dt;
                    TypeMirror var10_10 = lm.method().methodElement().getReturnType();
                    if (!(var10_10 instanceof DeclaredType)) {
                        throw new IllegalStateException("Expected declaredType");
                    }
                    DeclaredType modelType = dt = (DeclaredType)var10_10;
                    TemplateCompilerContext context = this.createForLambda(lm.name(), modelType);
                    String variableName = context.context.currentExpression().text();
                    String variableType = "var";
                    StringReader sr = new StringReader(rawBody);
                    StringBuilder lambdaCode = new StringBuilder();
                    lambdaCode.append(variableType).append(" ").append(variableName).append(" = ").append(entry.text()).append(";");
                    lambdaCode.append(compiler.run(context, sr));
                    yield lambdaCode.toString();
                }
            };
        }
        throw new IllegalStateException("bug expected lambda context");
    }

    public String beginSectionRenderingCode() {
        return this.debugComment() + this.context.beginSectionRenderingCode();
    }

    private String debugComment() {
        return "/* RenderingContext: " + this.context.getClass() + " */\n/* TypeMirror: " + this.context.currentExpression().type() + " */\n";
    }

    public String endSectionRenderingCode() {
        return this.context.endSectionRenderingCode();
    }

    public TemplateCompilerContext createForParameterPartial(String template) {
        return new TemplateCompilerContext(this.templateStack.ofPartial(template), this.lambdas, this.generator, this.variables, this.context, ContextType.PARENT_PARTIAL);
    }

    public TemplateCompilerContext createForPartial(String template) {
        return new TemplateCompilerContext(this.templateStack.ofPartial(template), this.lambdas, this.generator, this.variables, this.context, ContextType.PARTIAL);
    }

    TemplateCompilerContext createForLambda(String lambdaName, DeclaredType model) throws AnnotatedException {
        String modelVariableName = this.variables.introduceNewNameLike(lambdaName);
        TemplateStack templateStack = this.templateStack.ofLambda(lambdaName);
        return this.generator.createTemplateCompilerContext(templateStack, model, modelVariableName, this.variables);
    }

    public TemplateCompilerContext getChild(String path, ContextType childType) throws ContextException {
        return this._getChild(path, childType);
    }

    List<String> splitNames(String name) {
        return List.of(name.split("\\."));
    }

    private TemplateCompilerContext createEnclosed(String name, ContextType childType, RenderingContext enclosedField) {
        if (enclosedField instanceof LambdaRenderingContext) {
            childType = ContextType.LAMBDA;
        }
        return new TemplateCompilerContext(this.templateStack, this.lambdas, this.generator, this.variables, enclosedField, childType, new EnclosedRelation(name, this));
    }

    private TemplateCompilerContext _getChild(String name, ContextType childType) throws ContextException {
        Iterator<String> it;
        if (name.equals(".")) {
            RenderingContext enclosedField = this._getChildRender(name, childType, new OwnedRenderingContext(this.context));
            return this.createEnclosed(name, childType, enclosedField);
        }
        switch (childType) {
            case PARTIAL: 
            case PARENT_PARTIAL: 
            case BLOCK: {
                RenderingContext enclosedField = this._getChildRender(name, childType, new OwnedRenderingContext(this.context));
                return this.createEnclosed(name, childType, enclosedField);
            }
        }
        List<String> names = this.splitNames(name);
        if (names.size() == 0) {
            throw new IllegalStateException("names");
        }
        RenderingContext enclosing = new OwnedRenderingContext(this.context);
        RenderingContext start = this._getChildRender(it.next(), (it = names.iterator()).hasNext() ? childType.pathType() : childType, enclosing, false);
        enclosing = start;
        while (it.hasNext()) {
            String n = it.next();
            if (childType == ContextType.INVERTED) {
                try {
                    enclosing = this._getChildRender(n, childType, enclosing, true);
                    continue;
                }
                catch (ContextException.FieldNotFoundContextException e) {
                    if (this.templateStack.flags().contains((Object)Prisms.Flag.NO_INVERTED_BROKEN_CHAIN)) {
                        throw e;
                    }
                    enclosing = start;
                    break;
                }
            }
            enclosing = this._getChildRender(n, it.hasNext() ? childType.pathType() : childType, enclosing, true);
        }
        return this.createEnclosed(name, childType, enclosing);
    }

    private RenderingContext _getChildRender(String name, ContextType childType, RenderingContext enclosing) throws ContextException {
        return this._getChildRender(name, childType, enclosing, false);
    }

    private RenderingContext _getChildRender(String name, ContextType childType, RenderingContext enclosing, boolean direct) throws ContextException {
        try {
            return this.__getChildRender(name, childType, enclosing, direct);
        }
        catch (TypeException ex) {
            throw new ContextException(MessageFormat.format("Can''t use ''{0}'' field for rendering", name), ex);
        }
    }

    private RenderingContext __getChildRender(String name, ContextType childType, RenderingContext enclosing, boolean direct) throws ContextException, TypeException {
        Lambda lambda;
        JavaExpression entry;
        if (name.equals(".")) {
            return switch (childType) {
                default -> throw new IncompatibleClassChangeError();
                case ContextType.ESCAPED_VAR, ContextType.UNESCAPED_VAR, ContextType.PATH -> enclosing;
                case ContextType.SECTION -> this.generator.createRenderingContext(childType, enclosing.currentExpression(), enclosing);
                case ContextType.INVERTED -> throw new ContextException("Current section can't be inverted");
                case ContextType.PARENT_PARTIAL, ContextType.ROOT -> throw new ContextException("Current section can't be parent");
                case ContextType.PARTIAL -> throw new ContextException("Current section can't be partial");
                case ContextType.LAMBDA -> throw new ContextException("Current section can't be lambda");
                case ContextType.BLOCK -> throw new ContextException("Current section can't be block");
            };
        }
        if (childType == ContextType.PARENT_PARTIAL || childType == ContextType.PARTIAL) {
            return enclosing;
        }
        if (name.contains(".")) {
            throw new IllegalStateException("dotted path not allowed here");
        }
        if (childType == ContextType.BLOCK) {
            return enclosing;
        }
        JavaExpression javaExpression = entry = direct ? enclosing.get(name) : enclosing.find(name, c -> !(c instanceof MapRenderingContext));
        if (entry == null && childType == ContextType.SECTION && (lambda = this.lambdas.lambdas().get(name)) != null) {
            return new LambdaRenderingContext(lambda, this.variables, enclosing);
        }
        if (entry == null & !direct) {
            entry = enclosing.find(name, c -> true);
        }
        if (entry == null) {
            if (this.getTemplateStack().isDebug()) {
                this.getTemplateStack().debug("Field not found. field: " + name + ", template: " + this.templateStack.describeTemplateStack() + " context stack: " + enclosing.printStack() + " direct: " + direct + "\n");
            }
            throw new ContextException.FieldNotFoundContextException(MessageFormat.format("Field not found in current context: ''{0}'' , template: " + this.templateStack.describeTemplateStack(), name));
        }
        RenderingContext enclosedField = switch (childType) {
            default -> throw new IncompatibleClassChangeError();
            case ContextType.ESCAPED_VAR, ContextType.UNESCAPED_VAR, ContextType.PATH, ContextType.SECTION -> this.generator.createRenderingContext(childType, entry, enclosing);
            case ContextType.INVERTED -> {
                this.templateStack.debug("Invert entry: " + entry);
                yield new InvertedRenderingContext(this.generator.createInvertedRenderingContext(entry, enclosing), direct);
            }
            case ContextType.PARENT_PARTIAL, ContextType.ROOT -> throw new IllegalStateException("parent not allowed here");
            case ContextType.PARTIAL -> throw new IllegalStateException("partial not allowed here");
            case ContextType.BLOCK -> throw new IllegalStateException("block not allowed here");
            case ContextType.LAMBDA -> throw new IllegalStateException("LAMBDA not allowed here");
        };
        return enclosedField;
    }

    public boolean isEnclosed() {
        return this.enclosedRelation != null;
    }

    public Optional<EnclosedRelation> enclosed() {
        return Optional.ofNullable(this.enclosedRelation);
    }

    public String currentEnclosedContextName() {
        return this.enclosed().orElseThrow().name();
    }

    public TemplateCompilerContext parentContext() {
        return this.enclosed().orElseThrow().parentContext();
    }

    public String unescapedWriterExpression() {
        return this.variables.unescapedWriter();
    }

    public ContextType getType() {
        return this.childType;
    }

    public TemplateStack getTemplateStack() {
        return this.templateStack;
    }

    public String printStack() {
        return this.context.printStack();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ContextType {
        ROOT,
        ESCAPED_VAR,
        UNESCAPED_VAR,
        SECTION,
        LAMBDA,
        INVERTED{

            @Override
            public ContextType pathType() {
                return INVERTED;
            }
        }
        ,
        PARTIAL,
        BLOCK,
        PARENT_PARTIAL,
        PATH;


        public ContextType pathType() {
            return PATH;
        }

        public boolean isVar() {
            return this == ESCAPED_VAR || this == UNESCAPED_VAR;
        }
    }

    public static interface LambdaCompiler {
        public String run(TemplateCompilerContext var1, Reader var2) throws IOException, ProcessingException;
    }
}

