/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.prism.Prisms;
import java.io.PrintStream;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TemplateStack
extends LoggingSupport {
    public String getTemplateName();

    public @Nullable TemplateStack getCaller();

    default public String describeTemplateStack() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTemplateName());
        for (TemplateStack parent = this.getCaller(); parent != null; parent = parent.getCaller()) {
            sb.append(" <- ");
            sb.append(parent.getTemplateName());
        }
        return sb.toString();
    }

    default public TemplateStack ofPartial(String templateName) {
        return new SimpleTemplateStack(templateName, this);
    }

    default public TemplateStack ofLambda(String templateName) {
        return new SimpleTemplateStack(templateName, this);
    }

    public static TemplateStack ofRoot(NamedTemplate template, Set<Prisms.Flag> flags) {
        return new RootTemplateStack(template, flags);
    }

    @Override
    default public void debug(CharSequence message) {
        PrintStream out;
        if (this.isDebug() && (out = System.out) != null) {
            out.println("[JSTACHIO] " + this.getTemplateName() + ": " + message);
        }
    }

    @Override
    default public boolean isDebug() {
        return this.flags().contains((Object)Prisms.Flag.DEBUG);
    }

    default public Set<Prisms.Flag> flags() {
        TemplateStack caller = this.getCaller();
        if (caller != null) {
            return caller.flags();
        }
        return Set.of();
    }

    public record SimpleTemplateStack(String templateName, @Nullable TemplateStack caller) implements TemplateStack
    {
        @Override
        public String getTemplateName() {
            return this.templateName;
        }

        @Override
        public @Nullable TemplateStack getCaller() {
            return this.caller;
        }
    }

    public record RootTemplateStack(NamedTemplate template, Set<Prisms.Flag> flags) implements TemplateStack
    {
        @Override
        public String getTemplateName() {
            return this.template.name();
        }

        @Override
        public @Nullable TemplateStack getCaller() {
            return null;
        }
    }
}

