/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

public class VariableContext {
    public static String APPENDER = "appender";
    public static String ESCAPER = "escaper";
    public static String APPENDABLE = "unescapedWriter";
    public static String FORMATTER = "formatter";
    private final String appender;
    private final String escaper;
    private final String unescapedWriter;
    private final String formatter;
    private final Map<String, Integer> variables;
    private final @Nullable VariableContext parent;
    private final boolean escaped;

    public static VariableContext createDefaultContext() {
        TreeMap<String, Integer> variables = new TreeMap<String, Integer>();
        variables.put(ESCAPER, 1);
        variables.put(APPENDER, 1);
        variables.put(APPENDABLE, 1);
        variables.put(FORMATTER, 1);
        return new VariableContext(APPENDER, ESCAPER, APPENDABLE, FORMATTER, variables, null, true);
    }

    VariableContext(String appender, String escaper, String unescapedWriter, String formatter, Map<String, Integer> variables, @Nullable VariableContext parent, boolean escaped) {
        this.appender = appender;
        this.escaper = escaper;
        this.unescapedWriter = unescapedWriter;
        this.formatter = formatter;
        this.variables = variables;
        this.parent = parent;
        this.escaped = escaped;
    }

    public String escaper() {
        return this.escaper;
    }

    public String appender() {
        return this.appender;
    }

    public String unescapedWriter() {
        return this.unescapedWriter;
    }

    public String formatter() {
        return this.formatter;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    VariableContext unescaped() {
        return new VariableContext(this.appender, this.appender, this.unescapedWriter, this.formatter, this.variables, this.parent, false);
    }

    private @Nullable Integer lookupVariable(String baseName) {
        Integer result = this.variables.get(baseName);
        VariableContext p = this.parent;
        if (result != null || p == null) {
            return result;
        }
        return p.lookupVariable(baseName);
    }

    public String introduceNewNameLike(String baseName) {
        int subscriptIndex = baseName.length();
        while (Character.isDigit(baseName.charAt(subscriptIndex - 1))) {
            --subscriptIndex;
        }
        if (subscriptIndex == baseName.length()) {
            Integer count = this.lookupVariable(baseName);
            if (count == null) {
                this.variables.put(baseName, 1);
                return baseName;
            }
            this.variables.put(baseName, count + 1);
            return baseName + count;
        }
        Integer requestedCount = Integer.parseInt(baseName.substring(subscriptIndex));
        Integer currentCount = this.lookupVariable(baseName = baseName.substring(0, subscriptIndex));
        int count = currentCount == null || currentCount < requestedCount ? requestedCount : currentCount;
        this.variables.put(baseName, count + 1);
        return baseName + count;
    }

    VariableContext createEnclosedContext() {
        return new VariableContext(this.appender, this.escaper, this.unescapedWriter, this.formatter, new TreeMap<String, Integer>(), this, true);
    }
}

