/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.token.EndMustacheTokenizerState;
import io.jstach.apt.internal.token.MustacheTagKind;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.internal.token.MustacheTokenizerState;
import io.jstach.apt.internal.token.OutsideMustacheTokenizerState;
import org.eclipse.jdt.annotation.Nullable;

class IdentifierMustacheTokenizerState
implements MustacheTokenizerState {
    final MustacheTagKind kind;
    final StringBuilder name;
    private final MustacheTokenizer tokenizer;

    IdentifierMustacheTokenizerState(MustacheTagKind kind, StringBuilder name, MustacheTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.kind = kind;
        this.name = name;
    }

    @Override
    public @Nullable Void twoOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void threeOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void twoClosingBraces() throws ProcessingException {
        if (this.kind == MustacheTagKind.UNESCAPED_VARIABLE_THREE_BRACES) {
            this.tokenizer.error("Expecting three closing braces, not two");
        } else {
            this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
        }
        return null;
    }

    @Override
    public @Nullable Void threeClosingBraces() throws ProcessingException {
        if (this.kind == MustacheTagKind.UNESCAPED_VARIABLE_THREE_BRACES) {
            this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
        } else {
            this.tokenizer.error("Expecting two closing braces, not three");
        }
        return null;
    }

    @Override
    public @Nullable Void character(char c) throws ProcessingException {
        if (Character.isWhitespace(c)) {
            boolean expectsThree = this.kind == MustacheTagKind.UNESCAPED_VARIABLE_THREE_BRACES;
            this.tokenizer.setState(new EndMustacheTokenizerState(this.tokenizer, expectsThree));
        } else {
            this.name.append(c);
        }
        return null;
    }

    @Override
    public @Nullable Void endOfFile() throws ProcessingException {
        this.tokenizer.error("Unclosed field at the end of file");
        return null;
    }

    @Override
    public void beforeStateChange() throws ProcessingException {
        String nameString = this.name.toString();
        this.tokenizer.emitToken(new MustacheToken.TagToken(this.kind, nameString));
    }
}

