/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.token.BeforeIdentifierMustacheTokenizerState;
import io.jstach.apt.internal.token.MustacheTagKind;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.internal.token.MustacheTokenizerState;
import io.jstach.apt.internal.token.StartMustacheTokenizerState;
import org.eclipse.jdt.annotation.Nullable;

class OutsideMustacheTokenizerState
implements MustacheTokenizerState {
    private final StringBuilder text = new StringBuilder();
    private final MustacheTokenizer tokenizer;
    private char lastChar = '\u0000';

    OutsideMustacheTokenizerState(MustacheTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public @Nullable Void twoOpenBraces() throws ProcessingException {
        this.tokenizer.setState(new StartMustacheTokenizerState(this.tokenizer));
        return null;
    }

    @Override
    public @Nullable Void threeOpenBraces() throws ProcessingException {
        this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.UNESCAPED_VARIABLE_THREE_BRACES, this.tokenizer));
        return null;
    }

    @Override
    public @Nullable Void threeClosingBraces() throws ProcessingException {
        this.text.append("}}}");
        return null;
    }

    @Override
    public @Nullable Void twoClosingBraces() throws ProcessingException {
        this.text.append("}}");
        return null;
    }

    @Override
    public @Nullable Void character(char c) throws ProcessingException {
        switch (c) {
            case '\n': {
                this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
                MustacheToken.NewlineChar nc = this.lastChar == '\r' ? MustacheToken.NewlineChar.CRLF : MustacheToken.NewlineChar.LF;
                this.tokenizer.emitToken(new MustacheToken.NewlineToken(nc));
                break;
            }
            case '\r': {
                break;
            }
            case '\"': {
                this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
                this.tokenizer.emitToken(new MustacheToken.SpecialCharacterToken(MustacheToken.SpecialChar.QUOTATION_MARK));
                break;
            }
            case '\\': {
                this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
                this.tokenizer.emitToken(new MustacheToken.SpecialCharacterToken(MustacheToken.SpecialChar.BACKSLASH));
                break;
            }
            default: {
                if (this.lastChar == '\r') {
                    this.text.append("\r");
                }
                this.text.append(c);
            }
        }
        this.lastChar = c;
        return null;
    }

    @Override
    public @Nullable Void endOfFile() throws ProcessingException {
        this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
        this.tokenizer.emitToken(new MustacheToken.EndOfFileToken());
        return null;
    }

    @Override
    public void beforeStateChange() throws ProcessingException {
        if (this.text.length() > 0) {
            this.tokenizer.emitToken(new MustacheToken.TextToken(this.text.toString()));
        }
    }
}

