/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token.util;

import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.token.BracesToken;
import io.jstach.apt.internal.token.util.PositionAnnotator;
import io.jstach.apt.internal.token.util.PositionedTransformer;
import io.jstach.apt.internal.token.util.TokenProcessorDecorator;
import org.eclipse.jdt.annotation.Nullable;

public class BracesTokenizer
implements TokenProcessor<Character> {
    private final TokenProcessor<BracesToken> downstream;
    private State state = State.NONE;

    static TokenProcessorDecorator<@Nullable Character, BracesToken> decorator() {
        return new TokenProcessorDecorator<Character, BracesToken>(){

            @Override
            public TokenProcessor<@Nullable Character> decorateTokenProcessor(TokenProcessor<BracesToken> downstream) {
                return new BracesTokenizer(downstream);
            }
        };
    }

    public static TokenProcessor<@Nullable Character> createInstance(String fileName, TokenProcessor<PositionedToken<BracesToken>> downstream) {
        TokenProcessor<PositionedToken<@Nullable Character>> paransisTokenizer = PositionedTransformer.decorateTokenProcessor(BracesTokenizer.decorator(), downstream);
        return new PositionAnnotator(fileName, paransisTokenizer);
    }

    public BracesTokenizer(TokenProcessor<BracesToken> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void processToken(@Nullable Character token) throws ProcessingException {
        if (token == null) {
            if (this.state == State.WAS_OPEN) {
                this.downstream.processToken(BracesToken.character('{'));
            } else if (this.state == State.WAS_OPEN_TWICE) {
                this.downstream.processToken(BracesToken.twoOpenBraces());
            } else if (this.state == State.WAS_CLOSE) {
                this.downstream.processToken(BracesToken.character('}'));
            } else if (this.state == State.WAS_CLOSE_TWICE) {
                this.downstream.processToken(BracesToken.twoClosingBraces());
            }
            this.downstream.processToken(BracesToken.endOfFile());
            this.state = State.NONE;
        } else if (token.charValue() == '{') {
            if (this.state == State.WAS_OPEN) {
                this.state = State.WAS_OPEN_TWICE;
            } else if (this.state == State.WAS_OPEN_TWICE) {
                this.downstream.processToken(BracesToken.threeOpenBraces());
                this.state = State.NONE;
            } else if (this.state == State.WAS_CLOSE) {
                this.downstream.processToken(BracesToken.character('}'));
                this.state = State.WAS_OPEN;
            } else if (this.state == State.WAS_CLOSE_TWICE) {
                this.downstream.processToken(BracesToken.twoClosingBraces());
                this.state = State.WAS_OPEN;
            } else {
                this.state = State.WAS_OPEN;
            }
        } else if (token.charValue() == '}') {
            if (this.state == State.WAS_CLOSE) {
                this.state = State.WAS_CLOSE_TWICE;
            } else if (this.state == State.WAS_CLOSE_TWICE) {
                this.downstream.processToken(BracesToken.threeClosingBraces());
                this.state = State.NONE;
            } else if (this.state == State.WAS_OPEN) {
                this.downstream.processToken(BracesToken.character('{'));
                this.state = State.WAS_CLOSE;
            } else if (this.state == State.WAS_OPEN_TWICE) {
                this.downstream.processToken(BracesToken.twoOpenBraces());
                this.state = State.WAS_CLOSE;
            } else {
                this.state = State.WAS_CLOSE;
            }
        } else {
            if (this.state == State.WAS_OPEN) {
                this.downstream.processToken(BracesToken.character('{'));
            } else if (this.state == State.WAS_OPEN_TWICE) {
                this.downstream.processToken(BracesToken.twoOpenBraces());
            } else if (this.state == State.WAS_CLOSE) {
                this.downstream.processToken(BracesToken.character('}'));
            } else if (this.state == State.WAS_CLOSE_TWICE) {
                this.downstream.processToken(BracesToken.twoClosingBraces());
            }
            this.downstream.processToken(BracesToken.character(token.charValue()));
            this.state = State.NONE;
        }
    }

    private static enum State {
        WAS_OPEN,
        WAS_OPEN_TWICE,
        WAS_CLOSE,
        WAS_CLOSE_TWICE,
        NONE;

    }
}

