/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token.util;

import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import org.eclipse.jdt.annotation.Nullable;

class PositionAnnotator
implements TokenProcessor<Character> {
    private final String fileName;
    private final TokenProcessor<PositionedToken<@Nullable Character>> processor;
    private int row = 1;
    private StringBuilder currentLine = new StringBuilder();

    public PositionAnnotator(String fileName, TokenProcessor<PositionedToken<@Nullable Character>> processor) {
        this.fileName = fileName;
        this.processor = processor;
    }

    @Override
    public void processToken(@Nullable Character token) throws ProcessingException {
        if (token != null && token.charValue() != '\n') {
            this.currentLine.append(token.charValue());
        } else {
            String line = this.currentLine.toString();
            char[] chars = line.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                this.processor.processToken(new PositionedToken<Character>(new Position(this.fileName, this.row, line, i + 1), Character.valueOf(chars[i])));
            }
            this.processor.processToken(new PositionedToken<Character>(new Position(this.fileName, this.row, line, chars.length + 1), token));
            this.currentLine = new StringBuilder();
            ++this.row;
        }
    }
}

