/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token.util;

import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.token.util.PositionHodingTokenProcessor;
import io.jstach.apt.internal.token.util.TokenProcessorDecorator;

class PositionedTransformer<T, U>
implements TokenProcessor<PositionedToken<T>> {
    private final PositionHodingTokenProcessor<U> downstream;
    private final TokenProcessor<T> processor;

    public static <T, U> TokenProcessor<PositionedToken<T>> decorateTokenProcessor(TokenProcessorDecorator<T, U> decorator, TokenProcessor<PositionedToken<U>> positionedDownstream) {
        PositionHodingTokenProcessor downstream = new PositionHodingTokenProcessor(positionedDownstream);
        TokenProcessor<T> processor = decorator.decorateTokenProcessor(downstream);
        return new PositionedTransformer(downstream, processor);
    }

    private PositionedTransformer(PositionHodingTokenProcessor<U> downstream, TokenProcessor<T> processor) {
        this.downstream = downstream;
        this.processor = processor;
    }

    @Override
    public void processToken(PositionedToken<T> sourceToken) throws ProcessingException {
        this.downstream.setPosition(sourceToken.position());
        this.processor.processToken(sourceToken.innerToken());
    }
}

