/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class JStacheConfigPrism {
    private String _nameSuffix;
    private TypeMirror _contentType;
    private TypeMirror _formatter;
    private String _charset;
    private String _type;
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static JStacheConfigPrism getInstanceOn(Element e) {
        AnnotationMirror m = JStacheConfigPrism.getMirror("io.jstach.jstache.JStacheConfig", e);
        if (m == null) {
            return null;
        }
        return JStacheConfigPrism.getInstance(m);
    }

    public static JStacheConfigPrism getInstance(AnnotationMirror mirror) {
        return new JStacheConfigPrism(mirror);
    }

    private JStacheConfigPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._nameSuffix = this.getValue("nameSuffix", String.class);
        this._contentType = this.getValue("contentType", TypeMirror.class);
        this._formatter = this.getValue("formatter", TypeMirror.class);
        this._charset = this.getValue("charset", String.class);
        VariableElement typeMirror = this.getValue("type", VariableElement.class);
        this.valid = this.valid && typeMirror != null;
        this._type = typeMirror == null ? null : typeMirror.getSimpleName().toString();
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String nameSuffix() {
        return this._nameSuffix;
    }

    public TypeMirror contentType() {
        return this._contentType;
    }

    public TypeMirror formatter() {
        return this._formatter;
    }

    public String charset() {
        return this._charset;
    }

    public String type() {
        return this._type;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = JStacheConfigPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JStacheConfigPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JStacheConfigPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue nameSuffix() {
            return this.values.get("nameSuffix");
        }

        public AnnotationValue contentType() {
            return this.values.get("contentType");
        }

        public AnnotationValue formatter() {
            return this.values.get("formatter");
        }

        public AnnotationValue charset() {
            return this.values.get("charset");
        }

        public AnnotationValue type() {
            return this.values.get("type");
        }
    }
}

