/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class JStacheInterfacesPrism {
    private List<TypeMirror> _templateImplements;
    private List<TypeMirror> _templateAnnotations;
    private List<TypeMirror> _templateConstructorAnnotations;
    private List<TypeMirror> _modelImplements;
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static JStacheInterfacesPrism getInstanceOn(Element e) {
        AnnotationMirror m = JStacheInterfacesPrism.getMirror("io.jstach.jstache.JStacheInterfaces", e);
        if (m == null) {
            return null;
        }
        return JStacheInterfacesPrism.getInstance(m);
    }

    public static JStacheInterfacesPrism getInstance(AnnotationMirror mirror) {
        return new JStacheInterfacesPrism(mirror);
    }

    private JStacheInterfacesPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._templateImplements = this.getArrayValues("templateImplements", TypeMirror.class);
        this._templateAnnotations = this.getArrayValues("templateAnnotations", TypeMirror.class);
        this._templateConstructorAnnotations = this.getArrayValues("templateConstructorAnnotations", TypeMirror.class);
        this._modelImplements = this.getArrayValues("modelImplements", TypeMirror.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public List<TypeMirror> templateImplements() {
        return this._templateImplements;
    }

    public List<TypeMirror> templateAnnotations() {
        return this._templateAnnotations;
    }

    public List<TypeMirror> templateConstructorAnnotations() {
        return this._templateConstructorAnnotations;
    }

    public List<TypeMirror> modelImplements() {
        return this._modelImplements;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = JStacheInterfacesPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JStacheInterfacesPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JStacheInterfacesPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue templateImplements() {
            return this.values.get("templateImplements");
        }

        public AnnotationValue templateAnnotations() {
            return this.values.get("templateAnnotations");
        }

        public AnnotationValue templateConstructorAnnotations() {
            return this.values.get("templateConstructorAnnotations");
        }

        public AnnotationValue modelImplements() {
            return this.values.get("modelImplements");
        }
    }
}

